#include "RichEdit.h"

namespace Upp {

const VectorMap<String, Vector<Tuple<int, String>>>& UnicodeSymbols()
{
	static VectorMap<String, Vector<Tuple<int, String>>> map;
	ONCELOCK {
		const byte data[] = {
			120,156,164,125,5,120,28,71,210,182,29,102,114,226,216,137,19,175,157,216,142,172,40,96,135,233,130,151,99,102,158,221,
			109,237,142,53,59,51,25,144,180,62,10,231,248,194,204,204,204,204,204,204,204,201,221,5,44,217,82,238,46,127,189,213,
			61,51,61,180,210,125,255,147,199,209,78,85,53,85,87,87,87,119,87,87,215,141,192,152,184,220,242,126,187,85,117,44,
			127,57,195,243,156,1,127,57,191,105,184,194,95,161,110,218,141,170,17,248,171,180,140,160,41,232,127,102,205,176,150,154,
			184,220,231,213,21,38,76,152,48,123,194,132,73,85,203,168,245,85,252,208,174,12,152,65,179,226,25,109,127,34,193,151,
			173,89,78,88,95,138,126,173,16,182,170,158,176,44,99,105,250,88,222,183,157,129,150,97,47,195,36,78,75,4,203,210,
			175,149,84,38,129,225,45,135,207,129,166,25,8,254,92,158,62,87,180,204,70,51,176,169,38,43,208,215,42,65,51,180,
			235,194,243,3,199,107,173,72,128,165,169,236,149,232,239,106,134,95,19,54,42,92,177,157,186,88,153,64,171,215,69,10,
			182,10,193,86,174,57,246,130,208,174,5,166,99,175,138,194,28,215,117,124,19,159,171,33,137,172,74,32,44,225,54,29,
			91,172,14,152,172,79,12,91,131,171,108,88,150,19,84,170,206,224,154,244,185,78,242,41,249,80,107,138,90,223,90,132,
			89,51,139,25,156,196,124,48,172,192,244,196,218,244,123,74,196,160,136,131,166,93,169,123,142,235,175,131,230,54,145,86,
			244,11,207,104,136,201,200,79,49,167,233,52,204,138,107,138,154,88,151,75,145,28,76,160,83,192,122,234,197,150,231,212,
			250,166,210,199,198,30,114,241,69,189,226,57,129,17,208,223,94,203,241,12,171,210,20,134,71,101,132,150,37,130,245,136,
			112,170,204,203,18,189,65,197,117,76,59,0,251,76,226,249,224,250,132,93,79,98,61,244,73,6,61,13,137,101,245,10,
			18,111,64,216,117,37,54,116,51,184,13,145,177,196,21,101,60,61,201,184,238,12,216,25,108,133,176,107,251,125,84,255,
			138,97,215,43,53,207,241,253,42,117,147,63,3,252,171,25,33,250,182,226,155,13,123,38,1,214,240,140,186,233,24,212,
			255,253,130,129,27,65,118,170,166,211,52,22,26,94,157,65,27,131,119,53,163,30,214,68,232,207,162,143,101,12,187,175,
			57,27,132,142,23,52,157,58,245,37,23,51,7,93,89,107,154,21,175,233,108,130,110,96,104,197,233,173,16,107,209,145,
			162,139,160,107,197,208,5,194,11,169,231,69,107,46,136,33,224,170,202,44,167,65,55,42,220,107,120,190,89,145,195,113,
			83,72,26,213,151,58,214,232,11,204,30,164,162,46,109,9,153,206,55,107,125,150,216,12,169,92,97,212,132,74,181,57,
			170,223,38,41,106,27,118,99,11,84,32,32,174,122,70,171,210,235,120,232,238,126,97,111,9,86,232,96,203,232,19,243,
			178,192,94,18,209,249,24,229,58,80,13,192,173,178,196,3,212,27,91,163,134,41,32,73,154,183,13,122,72,135,182,156,
			208,14,136,61,219,102,201,33,138,205,237,228,152,19,194,2,207,234,77,195,107,25,219,163,22,82,4,122,73,65,65,27,
			84,122,169,201,59,160,121,106,72,180,76,43,2,239,8,176,26,19,26,120,167,36,151,148,198,218,25,228,212,88,63,168,
			236,19,82,21,4,170,232,216,187,160,122,150,145,129,126,1,157,78,93,80,11,189,246,174,208,40,189,164,24,45,41,76,
			187,65,175,113,35,118,135,230,138,225,123,32,205,130,208,165,146,189,61,233,247,114,190,17,132,158,189,23,126,134,158,97,
			135,254,23,65,97,11,55,8,109,177,55,114,113,173,48,112,190,132,95,134,103,10,255,203,32,13,140,144,4,232,43,248,
			217,16,45,211,54,191,138,159,53,195,174,9,239,107,208,133,150,112,190,142,36,253,166,215,112,190,129,95,150,89,245,140,
			111,178,50,168,57,158,107,134,254,183,80,103,223,104,152,1,201,31,125,127,27,53,173,25,174,103,18,129,253,29,144,26,
			104,47,161,190,139,236,93,147,132,211,255,30,186,91,178,142,116,27,137,115,31,49,245,251,137,66,146,192,125,66,33,236,
			31,100,73,61,199,233,251,97,210,81,18,88,53,73,91,185,63,202,130,251,108,40,128,31,103,179,112,141,1,251,39,0,
			202,78,77,170,240,211,68,251,105,85,248,89,150,20,85,248,121,34,20,122,21,126,145,5,203,42,252,50,155,5,170,240,
			171,4,232,187,70,29,98,100,6,70,82,89,169,75,1,172,38,13,171,155,70,203,193,112,37,112,45,153,99,106,86,88,
			101,88,61,73,159,100,42,146,146,146,76,123,147,170,234,153,54,146,73,42,206,180,137,94,198,228,225,83,199,218,13,223,
			132,150,136,196,216,118,2,177,0,4,2,45,109,242,119,31,207,230,194,104,209,204,160,129,125,139,224,147,21,220,55,7,
			3,226,110,132,106,161,220,86,72,106,136,230,18,35,96,73,183,81,69,9,179,33,227,52,193,0,236,160,57,18,76,186,
			204,115,25,232,178,248,8,26,95,126,219,51,141,154,84,170,251,0,42,140,12,212,195,20,17,218,38,230,48,202,211,19,
			181,118,141,199,181,50,92,228,12,151,6,74,117,213,118,69,207,150,21,23,227,216,172,249,65,103,194,121,49,97,216,153,
			112,126,76,216,223,153,112,171,152,112,160,51,225,214,49,225,96,103,194,109,98,194,118,103,194,109,99,194,133,68,56,187,
			144,176,33,108,65,35,191,210,130,162,54,13,203,255,53,145,86,164,140,149,179,251,55,176,121,36,144,196,194,37,91,209,
			83,152,223,18,102,186,75,98,70,121,89,237,158,66,154,223,97,62,160,79,50,4,73,152,34,20,9,196,239,165,62,33,
			205,95,107,26,102,68,190,47,102,193,186,41,88,133,247,108,185,95,234,115,222,254,169,207,249,7,164,62,183,58,48,245,
			185,245,65,169,207,109,14,166,207,245,213,192,49,61,170,167,156,18,234,52,108,216,14,57,36,177,75,116,124,48,224,128,
			198,255,3,161,103,168,193,172,161,35,75,69,101,242,199,132,161,217,76,98,74,255,79,104,57,13,104,39,158,10,49,121,
			255,153,71,77,10,106,218,127,129,33,85,79,230,204,134,39,208,119,156,224,175,232,23,13,103,145,226,18,156,234,111,24,
			198,5,24,74,244,247,12,42,206,208,180,15,157,29,155,227,52,194,27,135,205,142,141,117,124,30,142,241,175,217,35,46,
			217,35,71,96,202,160,9,169,233,120,71,194,96,226,193,11,213,49,224,120,117,255,40,182,213,2,163,183,23,83,187,65,
			102,79,104,25,152,148,142,230,73,145,22,23,194,63,6,51,33,140,164,170,89,59,22,96,178,83,7,132,119,28,236,176,
			6,169,194,227,81,106,156,71,147,196,72,248,39,64,153,25,129,211,82,34,115,34,91,82,150,8,189,158,186,232,177,76,
			255,36,104,55,39,12,72,134,169,50,201,2,227,100,130,79,11,154,158,32,155,149,80,126,133,150,7,36,243,13,136,58,
			247,222,41,16,145,18,2,88,185,167,162,164,1,195,99,139,4,50,124,26,27,105,148,180,210,239,88,1,89,237,12,61,
			29,229,215,157,176,138,177,160,25,12,103,128,58,130,199,208,51,33,50,100,227,10,207,34,235,61,73,1,38,199,68,103,
			129,151,49,88,203,243,108,8,1,127,177,160,249,129,231,244,73,204,57,132,233,202,97,226,92,51,249,156,75,212,27,82,
			91,121,209,87,41,204,240,60,84,148,186,218,92,232,144,65,87,66,116,62,218,78,211,135,25,182,42,250,96,186,64,131,
			235,227,227,66,130,79,85,112,159,114,180,82,169,46,226,73,135,150,169,38,243,150,187,251,98,72,90,221,236,119,188,216,
			8,190,4,29,27,218,76,200,234,199,11,72,209,249,77,211,85,4,151,178,233,228,244,246,154,246,101,108,197,145,225,133,
			217,138,204,178,203,129,178,69,72,252,191,2,54,20,89,87,194,191,146,109,33,170,141,225,95,5,81,164,69,164,115,53,
			219,90,52,129,25,215,112,110,77,211,115,236,107,19,139,4,230,34,137,141,69,12,185,14,82,237,139,193,192,180,196,245,
			108,129,145,1,167,190,111,128,205,181,79,104,218,181,208,30,188,17,109,241,133,79,223,52,93,215,61,26,138,55,49,189,
			83,163,122,84,176,156,188,25,244,85,195,23,248,184,133,145,152,217,169,153,125,162,125,171,102,120,120,70,72,34,236,83,
			183,216,183,205,142,77,223,24,12,251,233,118,205,164,208,200,239,152,29,175,237,83,228,119,242,0,150,139,120,238,104,26,
			83,21,124,223,5,85,5,163,186,42,154,38,214,52,88,255,223,13,70,97,29,116,15,253,88,85,217,77,50,241,189,80,
			58,106,41,33,137,89,252,64,124,31,161,166,192,60,78,70,106,178,174,189,95,67,230,22,189,15,204,142,215,152,145,125,
			68,203,32,201,156,7,99,109,196,67,151,166,30,255,33,140,221,186,233,27,60,250,106,134,247,48,76,97,199,109,154,97,
			173,25,250,143,160,246,208,105,143,130,197,132,174,248,150,137,205,132,199,80,76,83,88,45,17,232,26,159,51,127,28,237,
			146,146,170,214,162,113,113,79,72,25,161,22,250,79,162,7,109,167,66,211,159,215,126,138,62,102,26,22,73,27,89,76,
			162,66,75,215,158,1,163,45,215,208,248,17,120,164,235,204,218,211,24,142,106,123,98,192,41,36,121,6,36,106,183,162,
			132,228,89,40,7,109,133,143,154,85,72,129,55,196,115,192,104,203,247,4,243,60,134,92,221,227,21,51,233,98,30,212,
			47,160,210,88,75,182,43,201,202,188,39,94,153,211,162,142,102,22,75,188,136,193,192,217,81,31,99,30,224,22,191,196,
			42,92,201,172,218,10,121,153,96,91,244,146,64,35,57,245,94,195,177,105,52,82,247,165,230,95,250,86,189,206,169,95,
			65,207,40,158,120,97,173,239,85,244,12,13,86,42,190,134,45,14,46,153,139,236,217,242,181,114,220,188,215,193,56,3,
			58,203,118,90,172,238,52,19,73,46,208,222,32,146,110,217,96,125,26,215,116,104,100,22,84,140,170,211,47,222,132,44,
			185,148,191,129,137,245,45,152,10,60,161,244,52,137,86,212,149,122,39,51,132,148,83,68,245,54,212,41,234,213,137,232,
			29,140,88,19,147,80,160,131,223,77,58,86,237,55,144,228,55,77,97,213,223,195,224,163,159,118,224,16,132,86,3,226,
			125,41,137,161,87,107,126,192,63,169,233,150,248,16,116,77,19,59,107,48,211,137,235,255,192,160,198,156,27,15,245,102,
			88,253,39,186,52,6,86,80,83,154,181,255,197,74,219,112,117,198,241,198,29,37,243,197,71,144,247,104,213,255,49,26,
			16,111,122,81,53,27,30,97,234,159,128,166,87,209,124,42,39,112,3,123,60,52,193,88,98,17,84,109,175,240,188,246,
			16,232,124,195,180,170,142,17,12,67,79,73,89,160,34,67,82,37,180,134,37,61,191,24,228,126,159,41,188,37,232,7,
			19,243,66,31,141,174,17,180,136,204,77,223,81,203,127,168,208,81,12,244,128,24,249,25,180,219,2,195,197,104,21,132,
			178,251,84,115,254,13,67,144,58,191,78,204,161,81,65,252,238,23,109,222,46,98,244,127,80,70,111,40,172,138,27,182,
			220,255,162,78,181,208,69,211,116,97,253,156,224,155,37,198,148,98,159,54,121,154,117,226,100,148,132,196,212,21,183,206,
			33,153,149,214,71,221,108,9,219,55,121,84,240,208,186,109,78,156,93,52,218,96,156,128,123,108,139,104,51,103,132,191,
			157,146,172,74,173,119,177,41,10,211,203,187,131,32,43,59,244,77,139,198,170,47,130,59,65,161,190,193,38,17,220,69,
			144,245,121,172,248,61,188,43,76,122,151,42,95,23,150,217,194,118,198,221,132,159,38,119,237,138,9,238,33,130,181,28,
			47,49,173,73,255,153,117,113,47,129,43,106,79,178,226,59,164,89,67,90,99,211,122,65,240,126,173,172,206,125,68,180,
			94,84,19,29,43,233,239,39,244,70,177,133,82,141,69,50,225,169,28,158,15,160,142,250,22,54,217,118,190,174,103,30,
			68,179,45,135,33,253,38,184,252,16,65,54,72,37,201,234,166,135,231,196,162,71,202,132,230,160,26,247,76,253,17,180,
			55,11,119,188,71,231,196,186,57,154,155,228,78,49,84,16,81,18,103,30,35,146,85,140,8,65,128,199,209,124,65,166,
			48,150,73,100,236,162,99,80,133,208,37,139,179,238,63,193,93,3,227,88,109,155,74,225,143,147,63,137,228,161,139,213,
			149,84,193,105,244,83,132,94,157,17,14,76,157,202,2,82,222,79,207,193,22,41,103,150,0,159,1,97,47,54,88,19,
			216,179,204,49,131,102,7,108,231,6,36,178,207,113,118,12,225,93,90,192,158,39,216,116,46,130,39,119,206,87,90,187,
			21,204,225,62,172,159,23,192,199,12,13,210,190,200,37,0,222,10,105,134,32,221,242,18,151,224,68,166,57,83,189,76,
			176,213,24,198,164,0,189,66,160,169,170,82,138,199,82,97,179,94,126,149,176,51,45,103,161,176,81,81,234,109,232,217,
			106,91,23,26,47,180,196,107,115,146,165,161,99,215,104,188,247,248,76,170,58,239,117,194,111,222,1,47,11,70,157,184,
			171,42,36,67,125,111,80,154,45,198,76,195,109,75,18,189,137,113,162,204,32,169,231,10,114,126,139,136,102,228,137,50,
			89,189,77,84,179,83,50,45,173,3,61,93,213,35,174,137,224,29,34,157,147,25,49,96,121,17,237,187,232,228,124,182,
			82,35,41,154,247,208,138,130,252,82,68,239,23,215,79,9,76,138,244,131,146,250,21,209,126,8,69,89,214,108,154,236,
			2,199,132,10,34,131,206,138,146,252,3,189,91,218,252,226,52,255,204,85,137,139,193,206,24,205,45,114,13,130,189,51,
			225,155,254,191,136,118,147,130,252,11,137,247,237,34,85,132,233,128,154,148,82,118,177,138,221,143,40,86,95,136,77,57,
			67,30,118,184,78,176,63,193,214,209,96,216,17,34,177,163,161,114,0,97,166,104,44,168,133,158,213,142,90,113,32,33,
			167,234,141,77,97,15,34,236,100,45,169,86,203,131,187,96,94,105,9,53,220,33,104,129,86,23,206,129,70,116,35,238,
			163,63,16,197,134,26,133,204,40,69,242,71,34,153,158,205,164,106,202,227,61,69,243,39,162,169,228,178,201,16,253,153,
			136,102,200,25,45,37,199,114,204,240,138,132,184,251,23,162,154,169,230,181,14,100,127,37,178,238,210,204,48,234,96,193,
			4,142,171,180,239,223,136,126,243,242,108,163,4,85,39,192,110,134,76,243,119,74,179,217,152,101,164,146,28,74,73,54,
			29,187,152,164,94,135,117,69,211,124,106,236,196,147,197,225,93,241,52,95,76,112,4,17,172,39,51,240,106,188,189,212,
			19,144,109,24,209,29,137,14,86,233,9,175,246,152,82,36,71,17,201,198,106,0,199,25,21,17,30,141,174,81,132,73,
			150,185,34,143,137,251,89,173,16,10,135,237,177,73,63,119,34,59,174,11,107,69,98,49,239,198,216,53,113,60,1,214,
			142,135,227,66,179,177,144,140,30,108,17,157,0,78,182,132,225,135,152,214,37,179,162,137,27,181,57,17,114,172,115,178,
			223,128,121,166,56,41,123,235,36,12,152,56,15,157,56,98,247,201,68,49,73,3,249,202,172,58,165,11,59,97,53,154,
			167,101,130,83,209,111,190,219,196,38,111,100,57,166,170,115,26,250,173,140,32,116,79,71,187,213,122,155,113,103,16,96,
			181,248,44,153,65,103,102,234,18,141,141,179,88,102,82,164,105,130,179,161,137,156,170,101,238,19,138,92,201,231,160,98,
			197,72,216,23,231,18,122,247,12,155,57,115,182,94,13,175,85,81,39,255,38,190,60,90,182,198,139,83,178,13,98,83,
			227,60,202,102,183,255,175,108,192,196,243,41,151,61,255,111,185,176,173,20,87,231,2,202,104,143,255,207,140,80,161,11,
			255,239,220,137,164,173,78,13,188,232,255,206,157,216,162,11,221,139,255,239,220,73,42,131,230,93,242,127,231,78,92,29,
			228,115,41,229,179,86,44,152,162,229,6,237,10,45,48,46,195,236,22,127,169,156,251,89,82,47,135,46,201,160,228,10,
			75,183,45,175,192,244,147,161,138,20,20,106,195,68,87,98,252,103,136,148,186,139,105,174,130,236,235,219,12,154,117,74,
			181,185,26,186,39,218,100,210,77,130,107,8,177,70,132,160,9,152,42,40,172,107,49,51,71,192,204,138,235,58,88,9,
			113,2,125,101,120,61,97,246,82,85,40,54,147,171,202,125,1,147,72,211,176,122,117,50,189,82,55,100,27,195,11,58,
			179,229,242,134,208,224,141,152,65,163,42,144,30,52,107,216,244,30,32,13,220,19,121,170,68,139,50,222,121,186,9,205,
			193,216,99,118,209,226,216,9,27,145,137,127,179,206,24,105,134,72,199,150,91,160,181,34,132,4,221,218,5,135,13,5,
			138,39,143,219,244,28,244,201,231,118,66,204,74,181,66,239,254,192,161,154,168,217,232,14,76,241,217,163,158,220,154,212,
			79,165,185,19,10,63,90,52,102,22,167,21,223,50,252,230,93,152,64,35,138,220,62,25,147,220,141,222,143,72,12,31,
			7,122,126,223,61,104,80,188,215,166,213,249,94,176,36,70,240,223,251,48,46,80,91,172,240,98,168,127,63,56,30,239,
			49,196,235,120,150,212,7,48,102,210,184,72,187,63,216,133,125,39,54,51,20,254,33,180,33,77,236,83,37,123,253,138,
			17,40,251,229,225,100,58,142,9,185,32,181,190,83,176,71,226,185,61,166,170,10,204,127,41,201,123,20,153,165,76,102,
			69,148,46,224,49,204,216,85,103,32,48,181,197,149,20,105,54,9,30,199,60,166,227,101,242,132,224,9,76,146,210,122,
			144,100,79,66,228,105,205,74,189,92,148,225,83,40,80,67,103,243,123,186,43,62,208,111,58,161,215,160,206,245,159,233,
			138,61,7,98,216,179,93,209,238,234,128,217,104,144,153,206,150,201,115,172,221,164,37,174,129,159,143,205,126,101,58,233,
			200,23,18,179,191,0,251,34,38,120,211,174,57,45,90,131,4,216,133,237,53,109,51,104,191,132,242,193,21,104,201,24,
			250,50,184,30,125,84,108,209,224,49,204,13,213,251,226,21,168,30,89,88,143,224,221,206,104,157,255,106,50,24,212,250,
			157,6,142,195,58,95,29,225,189,6,134,83,133,104,124,250,196,68,195,127,29,220,241,155,97,111,47,85,221,245,156,122,
			88,11,222,96,109,76,217,88,62,43,14,233,51,101,145,138,209,148,227,155,68,180,229,88,68,145,209,108,213,149,48,190,
			5,241,35,65,178,101,107,104,36,23,37,123,27,181,36,249,50,107,77,62,108,236,123,7,35,34,192,145,165,83,111,219,
			70,203,172,189,11,229,87,188,117,94,40,57,239,193,174,239,68,159,21,165,247,193,203,180,203,136,26,192,3,106,142,252,
			160,43,62,155,81,219,34,31,66,222,139,142,197,163,36,255,224,1,145,59,210,78,8,254,9,113,18,244,203,235,161,158,
			246,146,131,28,238,212,127,229,176,250,54,233,71,24,59,5,105,85,245,63,206,161,83,173,251,164,164,100,89,207,79,75,
			74,150,216,69,232,47,108,254,244,208,202,218,104,139,250,16,134,76,118,143,146,108,13,207,160,69,194,48,43,86,5,212,
			109,133,197,93,236,108,145,78,85,188,49,185,4,214,122,213,140,55,52,71,48,208,240,157,73,62,10,58,53,48,93,43,
			244,63,195,183,218,18,192,247,191,49,228,248,224,32,22,11,90,183,247,199,70,146,90,196,252,135,200,54,146,167,16,29,
			233,254,219,133,13,113,211,110,127,142,31,45,250,49,161,155,212,188,13,239,199,10,187,230,72,166,114,95,79,76,80,236,
			203,163,161,150,2,202,167,49,155,79,181,116,130,202,166,90,166,59,218,100,208,183,19,24,181,44,161,214,73,182,190,100,
			231,49,102,57,194,76,82,251,162,58,124,249,110,214,50,3,118,14,179,66,166,73,26,106,197,76,147,52,212,74,153,38,
			105,168,149,51,77,210,80,171,100,154,164,161,86,149,21,151,131,71,131,175,214,29,245,149,172,185,52,119,148,34,146,228,
			140,88,189,59,58,89,42,164,83,44,89,163,91,9,72,231,204,214,236,86,7,80,157,242,90,171,27,43,70,77,61,199,
			6,32,87,127,82,119,70,123,171,141,137,132,98,109,162,232,214,41,228,30,181,154,126,34,147,38,161,95,135,232,231,166,
			54,63,121,207,91,206,101,121,242,201,68,62,45,183,13,171,17,172,139,26,230,247,92,53,138,41,68,177,126,138,34,221,
			198,169,132,223,48,133,207,53,114,61,34,89,85,109,24,200,186,175,223,29,31,181,203,109,114,9,158,214,29,31,216,235,
			224,13,8,188,174,164,38,85,208,86,166,155,196,109,216,29,159,115,231,112,211,187,225,207,204,233,228,217,32,153,205,0,
			169,77,57,5,154,129,218,69,62,139,131,128,204,236,142,167,1,5,217,136,32,83,116,123,95,71,110,156,109,140,84,161,
			179,8,188,182,114,126,144,30,28,138,75,179,129,144,5,166,17,115,114,41,212,44,180,73,46,133,66,116,117,39,247,14,
			184,225,42,167,185,89,184,162,239,238,78,188,126,117,248,166,104,95,100,81,197,173,20,100,89,187,180,246,0,50,50,193,
			178,200,205,48,156,227,190,145,54,128,66,109,14,84,220,53,41,212,22,144,75,109,165,151,91,69,108,217,205,62,17,236,
			107,148,30,131,254,188,162,180,241,186,141,102,128,249,144,233,248,28,68,38,133,15,73,131,13,104,164,217,138,40,54,215,
			142,13,6,156,30,156,104,66,247,39,89,198,117,150,243,211,214,148,102,155,177,210,168,121,41,147,116,27,232,175,14,73,
			123,61,26,46,52,91,110,75,116,179,11,233,212,252,86,167,149,141,76,179,93,169,118,138,198,89,32,90,219,119,171,205,
			210,188,10,51,76,171,176,149,59,80,146,173,199,72,82,220,200,29,41,229,198,99,241,7,153,236,68,132,219,143,135,176,
			176,130,59,83,234,93,199,159,186,184,174,187,80,38,83,179,173,140,150,207,131,95,192,52,50,96,244,139,220,182,146,233,
			137,90,96,73,79,146,93,65,149,178,150,227,165,153,150,235,110,221,216,124,86,22,140,180,154,35,163,169,56,193,238,148,
			160,39,91,53,73,25,101,99,88,45,135,230,84,46,155,148,241,30,148,98,86,110,214,139,90,163,175,219,247,44,156,31,
			35,202,232,108,121,175,52,115,216,243,42,116,163,161,243,69,204,120,90,30,25,244,222,168,126,199,246,102,203,255,18,132,
			52,87,169,142,45,254,50,68,109,60,204,252,10,88,83,204,204,76,150,95,69,63,117,102,123,186,192,175,113,67,59,87,
			59,157,226,235,24,221,137,249,21,173,85,34,241,85,219,230,156,207,55,208,5,62,41,219,32,94,72,73,19,140,177,223,
			100,171,130,177,85,210,187,17,133,52,183,152,226,91,221,241,101,132,200,121,144,214,92,223,238,78,60,246,229,44,73,192,
			239,116,39,30,247,49,240,187,221,241,74,41,99,34,71,147,230,247,64,161,93,83,202,83,124,31,179,162,116,18,210,103,
			197,31,192,156,144,96,167,223,176,162,213,2,251,55,97,63,226,135,132,159,158,247,45,138,125,158,64,243,163,110,220,6,
			211,104,126,12,203,86,7,196,174,84,63,129,168,20,240,48,90,132,56,112,41,69,15,252,148,8,55,41,97,103,138,24,
			186,229,103,32,238,144,107,60,73,130,248,231,16,173,49,114,78,37,248,5,68,171,10,63,135,130,109,109,37,60,77,97,
			87,18,131,253,151,148,98,190,146,136,255,37,221,175,186,149,79,66,177,72,114,54,6,122,58,90,77,20,82,84,49,23,
			233,231,235,69,68,53,20,85,46,253,76,83,143,38,181,204,166,84,138,72,200,250,40,199,138,34,138,94,100,163,45,89,
			10,137,26,9,17,47,94,10,137,154,32,210,86,56,133,68,102,66,84,94,220,130,204,212,158,161,193,196,30,145,246,65,
			100,203,24,174,19,90,68,56,167,3,223,117,218,86,103,229,163,147,218,88,146,196,27,207,57,82,62,95,136,118,250,65,
			239,192,152,74,109,86,143,157,198,237,204,14,53,49,57,48,138,246,233,196,14,157,208,27,131,29,58,173,223,153,29,58,
			105,63,178,29,75,154,20,237,64,66,91,46,47,138,118,16,180,99,201,150,162,109,39,180,99,214,97,33,209,238,60,22,
			107,117,219,40,183,19,243,107,202,97,199,206,28,239,152,254,55,148,126,151,49,59,162,99,22,191,69,35,198,234,159,142,
			57,252,142,167,31,93,177,86,225,18,254,123,76,119,177,53,168,128,251,18,112,175,177,88,198,251,186,99,181,106,63,202,
			233,43,157,89,151,148,131,27,157,157,155,184,63,42,54,38,39,185,102,99,84,255,0,84,108,44,134,166,170,214,177,21,
			7,66,32,203,139,116,13,211,139,72,253,131,96,132,149,229,150,162,60,24,211,106,135,230,166,136,15,65,21,202,91,148,
			162,253,67,122,1,166,111,116,214,245,61,181,63,194,64,78,239,156,21,80,253,9,26,73,171,102,41,225,159,81,108,118,
			195,173,128,238,47,68,55,175,179,6,149,19,98,24,121,149,114,178,191,98,214,239,156,76,109,197,164,211,253,141,210,109,
			217,57,29,79,194,233,84,127,167,84,91,116,78,133,141,161,116,162,67,41,209,202,158,128,211,4,231,121,24,44,55,245,
			205,77,58,28,0,91,12,224,36,131,41,142,192,222,75,4,96,146,35,9,210,165,57,52,171,62,149,140,132,121,147,170,
			212,81,216,56,200,117,14,39,57,134,237,230,244,197,192,138,81,17,22,45,234,60,199,54,107,254,177,224,40,239,58,244,
			112,107,122,216,109,91,241,67,230,71,11,6,211,194,138,10,14,34,108,35,80,219,143,211,211,73,123,56,74,25,73,83,
			97,186,227,41,221,86,69,229,105,13,40,76,120,130,158,144,55,187,163,148,137,184,21,38,60,17,131,49,185,243,208,129,
			242,36,8,175,186,252,216,169,13,39,99,42,213,214,10,29,72,79,73,10,31,163,154,167,18,229,182,227,210,255,188,207,
			131,29,217,184,57,167,81,218,237,254,183,180,73,197,79,199,254,199,56,230,190,124,177,103,96,127,232,127,73,153,20,122,
			102,122,211,101,60,137,85,65,103,161,208,241,77,181,217,164,103,131,197,255,91,161,49,83,207,1,139,255,199,98,227,196,
			231,82,226,185,74,23,202,3,151,164,179,34,159,29,109,77,125,30,204,209,14,228,217,53,248,249,188,144,211,233,163,78,
			41,200,252,2,232,150,82,226,108,214,23,230,178,214,178,179,181,180,32,190,40,151,181,158,93,150,250,226,28,83,210,89,
			107,109,6,249,37,57,166,100,50,207,208,95,42,181,98,181,234,68,222,64,188,124,66,25,151,117,179,179,106,22,197,249,
			93,78,184,181,83,184,80,74,252,21,88,112,103,17,156,228,202,92,18,57,151,184,87,229,146,168,57,205,189,58,87,57,
			117,52,63,96,95,147,171,92,116,48,63,96,95,139,9,41,98,162,54,155,198,219,169,69,238,66,215,97,25,26,121,204,
			64,90,217,63,10,151,186,3,117,236,231,12,94,143,221,23,24,85,150,225,186,152,96,244,3,91,255,6,232,197,60,22,
			76,215,143,110,253,27,179,185,164,176,55,161,97,217,120,56,172,195,43,131,55,119,35,10,133,50,19,6,111,233,214,221,
			117,28,139,64,183,118,199,231,4,234,40,72,221,156,184,173,59,190,248,20,157,200,40,204,237,192,164,238,10,70,251,52,
			119,116,23,29,109,56,53,70,222,217,29,159,132,40,200,93,137,88,171,173,165,208,45,56,128,87,197,222,157,200,105,116,
			212,81,124,96,175,232,239,201,209,167,79,114,179,244,247,242,222,138,78,159,217,141,202,38,184,15,246,191,138,45,2,35,
			160,133,29,228,251,153,57,169,83,45,101,166,61,0,230,228,206,179,20,242,65,216,19,178,207,216,60,225,66,147,115,244,
			208,119,31,194,132,23,121,110,117,164,124,184,59,62,198,74,81,0,247,8,100,54,202,165,132,230,81,222,49,148,194,16,
			5,113,66,76,32,90,230,4,142,247,24,90,29,34,52,10,174,68,193,219,206,108,216,143,19,112,37,220,55,115,43,45,
			195,235,123,2,114,198,145,86,98,190,60,137,100,58,8,6,199,83,4,92,93,3,162,42,79,103,97,102,191,120,6,217,
			7,158,97,251,140,120,22,159,174,231,248,194,163,209,96,60,215,141,155,237,180,84,51,132,241,60,253,94,174,217,110,152,
			194,120,1,63,221,166,99,133,254,139,221,124,243,216,247,67,255,165,238,100,59,19,215,136,125,50,217,108,227,229,238,248,
			228,41,18,118,194,241,133,191,87,186,57,202,78,40,20,211,57,149,65,141,127,21,153,214,66,215,172,59,175,209,207,101,
			155,52,93,249,175,211,175,101,22,138,208,127,3,216,62,92,124,244,223,228,250,185,14,13,80,251,45,254,93,111,137,192,
			241,223,166,223,43,244,135,86,13,247,32,223,193,7,92,247,40,59,251,93,148,153,57,93,229,205,212,247,164,226,75,159,
			170,50,230,125,238,180,32,210,84,153,196,31,116,227,108,57,198,102,115,248,16,54,231,152,7,33,177,223,88,164,239,252,
			127,192,250,143,237,148,241,166,250,39,12,78,125,198,31,111,194,127,161,154,154,53,54,222,116,31,65,243,192,107,79,74,
			148,99,139,143,211,16,202,233,19,116,161,47,234,182,241,41,15,180,208,247,41,159,10,95,94,141,110,155,41,123,191,223,
			108,64,35,88,98,81,55,156,234,58,80,218,78,63,145,13,241,26,175,3,25,238,168,35,191,225,177,8,171,166,204,113,
			241,88,132,190,82,200,75,198,106,11,244,152,168,81,150,35,80,12,250,17,20,51,51,118,55,171,10,203,25,24,5,215,
			66,250,22,209,13,205,207,48,170,125,1,207,172,4,248,111,140,254,40,248,130,186,201,137,148,174,33,67,86,48,228,191,
			60,183,199,177,211,18,87,252,207,187,249,78,168,101,249,53,82,17,102,149,22,105,174,17,250,81,0,130,9,159,78,156,
			176,60,130,159,80,47,78,164,223,203,246,58,141,70,123,41,250,181,186,186,10,29,7,198,35,216,26,182,242,215,11,164,
			171,152,191,12,1,39,251,161,237,97,205,201,155,29,209,245,89,127,89,228,172,80,203,209,239,53,107,212,112,191,102,96,
			97,71,86,66,232,247,45,79,208,117,136,2,254,197,156,182,74,203,13,56,70,251,43,32,45,46,217,87,157,129,21,81,
			151,170,103,214,27,156,144,107,176,18,193,86,226,160,93,21,28,6,174,12,242,126,7,35,223,89,133,126,175,216,50,173,
			190,54,238,147,175,74,95,83,57,210,85,165,97,57,85,81,17,161,231,184,162,199,232,197,61,130,213,8,187,182,142,53,
			90,124,191,192,95,157,16,235,165,16,212,227,61,196,54,82,138,150,105,172,129,116,18,193,172,64,42,210,115,182,191,38,
			234,74,43,100,165,11,153,195,107,17,108,253,1,99,144,189,152,84,8,53,29,63,9,85,204,71,245,82,216,181,81,19,
			149,186,1,99,43,244,117,244,58,232,20,190,243,168,1,39,203,52,118,73,154,117,9,61,37,23,47,76,33,167,200,218,
			218,101,181,157,74,248,85,83,136,245,8,178,86,220,102,230,7,194,214,172,79,224,105,5,205,138,9,166,161,164,124,53,
			98,252,6,132,159,148,52,45,134,111,136,26,196,113,209,0,153,78,144,85,168,59,6,248,206,45,180,50,147,52,29,39,
			136,32,51,8,178,178,116,105,164,185,66,120,51,65,17,5,142,112,224,46,186,17,228,38,14,186,182,49,179,48,29,130,
			77,249,64,32,8,196,44,136,125,130,214,131,73,204,38,84,165,24,165,38,11,18,235,57,106,124,233,176,77,50,48,68,
			160,232,130,160,105,176,56,198,228,92,48,93,67,144,33,97,27,117,167,155,192,75,211,8,222,20,227,13,145,238,104,62,
			146,108,225,72,66,24,38,8,182,85,119,26,155,209,239,101,2,163,230,108,14,96,53,244,60,51,112,182,160,223,43,32,
			140,88,96,135,193,150,248,240,133,168,99,35,103,30,125,172,6,237,210,32,51,3,103,59,66,204,7,8,202,174,30,66,
			192,0,218,10,60,116,13,171,197,95,91,211,215,114,53,163,22,132,254,54,24,175,40,217,21,240,161,218,22,138,38,8,
			45,211,221,14,153,80,137,158,215,70,85,125,223,105,109,143,154,193,24,217,1,21,104,154,85,211,39,43,106,71,100,77,
			12,149,81,118,118,226,74,75,250,157,209,251,184,231,239,244,146,177,100,46,20,187,160,175,21,128,70,179,248,2,50,164,
			34,170,187,242,96,129,121,102,9,163,23,125,66,13,218,13,85,107,25,46,223,230,50,122,119,71,98,248,173,11,155,191,
			247,160,239,117,153,188,151,76,37,248,170,203,123,27,96,238,158,168,96,43,244,155,158,227,180,246,66,107,201,22,37,155,
			238,139,168,171,17,86,57,254,142,216,27,136,134,135,64,165,95,66,187,91,164,250,237,47,199,10,140,63,191,130,20,88,
			229,32,127,241,85,144,89,130,204,166,175,33,109,213,176,233,191,175,51,111,9,75,75,22,75,124,3,95,188,137,138,175,
			111,162,210,178,103,248,251,91,104,177,75,44,248,54,114,66,208,197,230,119,84,215,34,206,140,255,93,148,14,93,54,80,
			5,231,191,135,204,154,70,139,164,128,42,240,125,116,137,111,33,22,1,49,208,53,23,46,52,126,0,22,183,4,105,95,
			196,10,160,153,226,135,40,208,117,66,43,240,224,113,209,248,17,8,192,107,210,25,112,205,244,126,204,245,3,0,11,169,
			159,128,188,38,207,104,1,252,41,247,122,136,78,151,107,249,154,248,25,15,217,64,24,45,94,143,57,3,214,207,185,199,
			93,163,209,20,65,96,254,2,45,161,137,200,168,255,18,101,245,122,194,174,209,232,71,107,126,133,65,226,57,184,73,128,
			0,78,2,87,240,97,145,59,6,210,212,137,171,78,21,12,113,234,148,6,32,50,91,155,102,93,102,131,168,59,136,54,
			209,114,5,244,81,175,233,55,43,53,163,47,114,251,31,48,61,171,66,118,40,205,224,189,204,23,7,87,66,185,157,84,
			213,6,243,177,105,96,145,79,192,38,106,28,35,77,112,188,14,247,13,26,76,11,120,44,16,7,76,209,199,26,180,233,
			212,28,108,173,97,225,107,161,82,52,119,213,219,45,164,177,28,56,98,57,174,205,83,115,8,245,85,119,184,139,136,243,
			109,180,205,101,214,224,76,25,85,221,7,95,56,91,118,176,92,245,100,215,240,69,252,94,199,169,251,156,11,74,182,27,
			1,154,64,22,90,31,179,189,207,54,123,69,136,57,152,216,142,64,16,113,244,12,142,149,209,15,253,235,131,21,88,100,
			169,184,75,68,54,192,162,139,45,96,118,238,31,228,190,116,106,125,236,216,195,160,54,64,100,27,185,108,25,213,73,164,
			251,22,162,97,85,1,37,31,54,126,45,149,23,129,185,175,21,212,255,13,106,94,53,170,109,85,224,111,121,98,76,213,
			86,246,138,11,198,253,14,179,152,170,153,132,58,114,45,95,163,20,191,71,163,9,128,93,233,125,193,122,185,79,177,31,
			84,236,0,13,69,108,130,187,52,137,17,211,246,231,153,192,164,169,190,110,180,185,235,15,64,245,23,144,24,247,56,61,
			236,22,224,217,7,74,53,69,166,76,208,50,164,174,59,136,149,9,238,70,123,149,24,115,48,186,2,225,72,7,168,18,
			254,33,208,194,209,23,130,38,122,125,150,240,254,192,186,11,219,11,142,253,71,8,33,130,62,181,185,250,194,251,19,11,
			135,99,247,66,230,121,236,252,25,16,82,13,70,213,8,12,46,249,47,114,10,150,1,203,16,162,195,255,43,218,5,221,
			64,162,74,77,230,75,197,127,147,173,80,65,66,234,36,83,254,223,57,33,135,53,12,32,161,194,59,84,245,37,117,108,
			211,108,137,195,32,12,60,219,246,155,130,167,13,196,148,34,61,212,62,156,133,159,164,22,198,176,17,144,34,177,142,0,
			136,244,90,61,148,151,152,201,178,59,18,179,166,140,3,25,123,227,226,78,119,83,158,31,28,133,126,39,107,100,159,80,
			72,241,100,93,238,31,141,140,16,254,148,4,189,141,189,2,195,58,6,13,242,16,59,180,206,39,123,232,188,99,49,62,
			57,54,35,9,85,159,104,87,29,68,54,225,114,208,89,254,113,224,182,31,132,117,211,169,180,76,226,15,71,65,62,30,
			28,38,97,22,22,135,69,18,222,9,138,195,176,221,73,168,156,170,127,34,65,54,84,161,35,147,232,204,81,73,28,66,
			242,36,34,153,174,72,180,104,205,41,154,147,121,230,48,105,242,235,245,136,208,63,5,245,161,165,169,233,243,157,48,220,
			101,22,129,127,42,75,146,225,33,220,140,133,13,48,95,156,198,154,8,154,25,123,101,66,88,167,131,134,170,103,65,180,
			88,175,121,103,160,103,160,156,216,141,199,137,162,160,17,224,76,158,191,226,246,158,197,170,154,86,53,164,133,208,195,198,
			217,172,121,72,54,90,198,57,172,68,72,133,50,229,185,40,5,17,16,125,196,54,36,11,40,16,231,65,52,229,102,75,
			112,62,235,108,211,171,97,110,167,113,114,1,207,111,220,136,11,153,133,216,59,131,205,142,110,184,136,5,80,120,88,253,
			241,177,143,23,248,23,163,98,184,105,231,84,26,84,147,75,240,41,189,244,42,100,29,93,138,122,250,216,98,107,209,236,
			68,213,187,140,181,152,73,170,15,139,209,203,161,47,144,172,82,55,197,21,60,98,28,156,59,53,174,132,178,151,130,3,
			61,208,102,33,69,138,171,184,225,90,135,92,77,128,201,124,87,7,115,123,170,171,174,97,253,105,12,74,150,93,203,19,
			52,34,164,122,215,97,80,103,101,236,122,230,138,23,210,20,17,220,0,218,126,211,161,170,220,8,46,68,180,136,90,43,
			110,130,173,224,133,182,12,108,211,52,163,97,224,27,126,243,102,224,136,143,54,117,50,77,145,60,4,120,95,18,177,209,
			80,170,223,103,202,219,57,244,183,74,150,235,173,80,191,85,195,39,126,131,134,113,52,252,220,219,164,42,162,165,165,240,
			212,248,191,29,93,5,115,145,171,43,188,59,88,227,81,61,132,119,39,126,250,161,71,226,117,23,115,220,165,73,195,151,
			131,236,110,238,81,200,77,251,30,224,88,24,81,57,170,254,189,44,188,114,53,100,99,30,225,74,220,199,130,25,54,72,
			69,71,160,251,193,28,154,38,17,93,241,1,112,100,128,163,178,146,165,218,75,98,251,32,179,214,177,168,248,135,144,163,
			204,156,12,122,178,87,57,226,230,195,144,10,5,165,110,124,4,189,91,243,88,202,136,53,9,139,30,101,97,194,144,104,
			227,243,49,57,87,11,11,60,33,226,118,197,231,88,1,17,249,227,152,58,48,19,231,176,110,88,235,123,130,176,211,2,
			131,195,187,200,30,113,13,142,105,20,37,127,18,213,0,67,161,212,48,87,68,139,218,167,120,50,53,90,152,104,158,230,
			14,130,109,165,110,7,168,117,242,51,24,170,209,74,22,119,194,124,196,252,130,138,124,22,163,132,3,77,37,43,221,231,
			32,138,241,202,248,121,72,9,245,160,32,243,43,168,164,73,95,144,179,38,205,175,242,106,154,2,191,8,22,147,78,18,
			94,240,18,248,47,127,86,76,120,180,213,95,6,196,102,253,76,73,48,1,189,194,253,21,24,216,144,125,21,221,153,46,
			228,53,244,146,4,113,163,26,16,40,251,117,84,28,49,8,107,9,229,27,224,81,60,191,184,112,216,148,20,111,2,33,
			151,217,134,173,35,222,194,152,110,58,190,75,35,205,122,155,62,150,65,232,170,119,48,143,27,33,91,206,56,167,22,172,
			246,148,82,120,23,150,17,173,27,132,245,30,4,0,6,123,133,63,223,71,61,57,198,165,109,226,234,95,5,225,192,196,
			7,44,237,60,75,125,136,49,85,199,78,74,192,97,137,24,255,15,52,158,86,66,244,187,253,79,180,201,92,104,244,25,
			109,163,162,166,249,127,1,22,183,73,134,27,251,8,176,184,57,18,246,49,11,122,116,83,129,172,243,224,147,79,227,245,
			164,130,124,138,26,14,24,253,201,49,4,134,234,34,13,154,68,40,29,66,189,176,228,33,29,60,156,228,164,32,139,193,
			4,203,168,10,107,9,253,154,81,197,156,66,198,158,157,210,35,126,51,132,41,4,67,108,132,115,128,199,171,173,118,242,
			70,145,63,73,45,141,112,227,51,250,189,17,205,233,11,76,146,234,186,73,131,8,1,212,131,133,174,129,136,115,125,42,
			16,113,207,188,127,163,172,177,232,230,255,103,60,84,91,253,119,60,84,91,127,62,30,170,109,38,44,162,37,46,153,56,
			19,23,97,45,5,73,93,138,126,45,229,12,46,189,8,157,194,123,66,213,176,151,150,112,206,50,32,173,57,3,203,130,
			52,48,105,109,179,28,253,90,222,18,14,137,69,125,249,69,208,146,70,181,106,6,43,48,161,17,172,8,80,221,195,78,
			223,74,139,48,46,61,178,210,235,166,37,86,70,14,3,77,154,37,87,193,47,223,38,91,119,85,245,171,79,172,182,136,
			165,148,180,231,234,178,114,173,53,232,239,50,13,199,8,214,100,34,154,212,221,181,144,55,153,82,164,142,38,45,226,238,
			118,48,177,175,141,223,36,235,164,166,236,117,144,154,214,230,147,241,215,53,27,235,34,23,232,244,41,244,99,5,126,215,
			129,4,107,42,82,56,36,195,110,232,175,183,136,117,186,201,241,171,177,201,183,62,146,86,195,198,52,252,37,226,13,22,
			241,152,163,117,3,153,217,27,210,199,202,150,81,199,246,163,32,97,153,142,252,121,197,3,214,197,6,59,32,51,144,14,
			123,7,248,152,137,170,7,161,71,73,54,90,4,149,1,3,144,149,27,234,189,49,129,86,98,179,157,63,103,209,231,186,
			189,30,25,88,61,189,82,175,39,184,217,220,32,211,171,207,65,27,104,160,208,172,107,111,2,22,245,57,134,101,116,161,
			28,151,214,44,150,152,75,63,87,175,123,14,38,42,175,205,166,140,213,141,178,171,52,122,177,35,45,65,155,34,31,178,
			109,93,170,78,15,234,193,2,193,155,29,155,161,5,53,28,57,210,199,230,192,177,4,240,231,22,96,132,236,122,254,222,
			146,105,13,249,49,15,72,41,4,252,61,31,197,210,188,25,6,114,40,147,16,108,181,136,183,51,60,85,212,214,72,33,
			187,150,191,183,89,196,43,63,185,233,178,45,62,168,51,249,99,59,72,21,49,71,126,109,143,222,163,117,55,228,64,62,
			19,0,244,0,77,151,242,117,128,69,188,174,51,36,110,39,148,73,154,169,110,240,231,206,81,182,54,41,137,93,36,110,
			160,130,32,234,129,255,5,110,78,211,116,91,161,221,183,43,120,46,218,194,223,13,34,65,63,118,231,191,134,183,7,16,
			72,189,167,26,73,65,115,47,238,104,135,186,69,124,113,81,188,141,165,191,131,1,95,105,44,15,229,155,22,123,19,209,
			204,162,23,47,210,100,95,74,200,210,47,110,164,201,190,76,100,27,21,62,175,145,166,251,202,34,172,188,76,94,238,55,
			229,3,19,13,251,171,0,42,197,26,3,191,6,6,59,125,9,224,235,232,203,160,73,83,181,143,102,1,244,13,36,84,
			32,110,4,128,223,36,224,164,90,116,58,140,228,114,23,255,91,16,75,246,152,77,96,223,6,251,106,112,206,253,14,186,
			97,128,38,50,219,135,5,253,93,124,18,195,121,77,44,252,239,65,86,109,65,11,101,83,124,31,191,131,30,182,17,127,
			128,244,11,104,114,241,127,136,95,117,90,150,250,63,66,71,244,153,136,169,253,99,252,172,154,180,84,54,127,130,218,171,
			252,107,100,58,55,133,255,83,36,113,67,146,196,159,33,75,212,170,106,52,126,206,80,39,172,53,127,1,25,226,4,126,
			211,17,191,196,56,167,37,43,25,251,28,225,222,17,191,66,235,17,6,186,7,11,15,222,11,113,132,193,154,84,150,227,
			67,226,172,42,24,169,32,48,78,253,26,218,6,27,80,74,92,125,17,86,118,161,31,112,32,91,211,34,11,2,51,151,
			0,27,1,246,211,240,94,214,82,78,187,193,106,210,244,172,38,0,148,187,201,122,22,229,44,64,179,123,13,90,22,182,
			251,22,97,225,103,200,59,239,140,68,168,205,122,220,51,214,34,108,97,12,208,170,79,100,48,45,232,34,142,96,238,228,
			112,54,152,73,43,41,185,207,5,251,196,115,144,145,44,64,94,150,36,19,186,141,199,62,124,119,145,58,131,16,209,197,
			39,211,218,135,96,147,83,49,58,45,156,115,34,34,188,135,118,199,217,52,66,163,226,210,156,102,56,62,178,137,225,164,
			81,201,0,10,208,67,84,49,54,122,236,16,170,68,126,113,69,250,89,99,146,2,29,96,137,212,140,201,10,54,21,132,
			55,200,122,128,58,161,70,98,211,70,199,197,246,139,211,240,196,194,69,186,69,211,64,156,34,251,215,96,114,131,12,177,
			224,55,177,234,198,214,163,245,91,180,72,12,6,56,124,242,100,8,90,56,126,89,100,97,253,142,37,7,191,104,110,182,
			161,176,126,143,46,51,91,238,190,60,195,225,93,155,253,192,109,211,198,26,80,238,8,144,41,10,115,8,28,218,31,173,
			36,70,208,66,141,90,117,0,207,179,252,30,200,129,168,63,238,29,194,66,63,8,173,199,220,138,37,46,77,60,7,67,
			236,160,237,136,53,190,111,52,196,33,82,200,177,42,13,254,176,136,183,139,60,62,209,162,21,241,31,129,195,91,12,212,
			148,63,129,109,46,45,38,255,140,114,251,104,9,206,231,232,127,225,9,80,94,70,194,94,238,95,65,134,4,127,227,234,
			9,220,197,161,185,242,239,0,35,209,161,139,120,225,201,27,22,135,45,98,139,147,175,83,73,231,21,236,115,28,14,138,
			1,81,135,92,29,1,30,145,190,102,149,197,216,35,81,255,42,92,158,109,9,56,138,231,33,196,89,193,151,127,52,122,
			71,238,11,197,105,142,65,46,13,79,238,218,51,228,88,30,163,201,174,10,155,116,199,113,215,89,161,122,204,227,248,69,
			241,14,48,127,159,128,146,219,100,16,208,4,200,128,19,1,32,69,129,234,51,224,36,180,71,203,85,110,178,156,140,178,
			60,65,43,173,254,184,124,255,148,164,2,201,254,210,169,4,156,30,63,239,1,191,82,85,59,45,120,234,105,16,90,233,
			195,73,250,70,158,247,87,67,171,122,58,42,195,187,221,234,84,233,12,22,115,167,85,61,147,57,98,145,189,148,188,226,
			112,22,138,175,97,83,84,6,215,97,224,217,144,85,31,15,71,176,37,226,15,96,119,90,162,206,97,163,64,158,234,156,
			203,147,57,174,102,74,220,121,248,38,193,144,123,219,142,115,62,184,221,107,137,65,120,124,144,14,112,253,11,80,183,186,
			185,112,97,91,37,185,80,206,255,66,212,100,24,94,199,177,47,66,45,177,87,202,13,146,176,139,89,69,42,67,31,219,
			19,151,64,155,32,114,56,150,233,60,149,249,81,76,119,86,202,188,153,75,202,250,50,22,172,208,195,142,54,105,155,193,
			90,19,156,185,92,117,79,127,155,247,238,12,249,242,196,21,168,126,141,50,36,195,5,187,30,87,130,11,88,69,97,91,
			67,242,191,45,228,20,118,21,161,166,166,81,90,70,87,99,172,166,177,88,227,48,238,154,69,216,89,77,225,92,68,62,
			102,228,181,232,12,89,119,198,64,76,253,235,8,56,139,234,29,201,82,226,106,41,108,25,48,61,170,213,245,232,104,159,
			250,234,6,180,79,234,6,210,49,8,217,130,152,173,55,130,51,164,103,69,47,45,180,196,77,208,13,120,63,168,110,250,
			181,155,209,116,226,172,235,18,71,76,191,239,22,158,219,93,121,89,0,4,183,66,33,213,251,235,183,45,146,251,112,240,
			196,129,34,189,29,53,230,57,91,3,222,193,218,31,97,27,229,21,182,208,179,238,140,65,202,110,13,221,187,22,177,93,
			104,81,43,12,239,110,212,56,160,81,208,67,211,69,37,130,222,131,113,136,174,144,182,201,189,224,93,25,39,238,35,228,
			122,26,82,119,132,37,244,253,220,120,3,219,201,68,242,0,190,106,164,25,121,83,231,65,200,52,25,252,77,26,23,15,
			65,102,57,22,117,69,65,30,94,196,231,110,196,78,36,120,132,5,150,180,56,143,55,4,10,241,30,5,15,164,39,7,
			130,102,73,224,99,172,175,28,167,15,170,17,247,45,252,199,161,151,201,10,160,129,249,4,154,14,1,0,193,147,244,177,
			97,244,161,234,174,20,65,63,162,117,246,11,239,41,150,76,233,49,0,170,167,121,90,3,215,241,245,12,184,36,213,19,
			62,159,229,150,66,121,225,235,57,158,243,60,72,61,127,63,143,25,5,63,252,23,144,204,198,46,32,45,122,27,226,197,
			69,188,188,199,206,232,75,144,163,22,45,22,95,134,229,17,191,121,7,103,65,129,215,96,94,65,30,232,76,239,85,22,
			7,99,48,218,82,120,13,221,232,27,216,103,144,190,129,216,2,50,94,71,215,184,33,77,143,181,138,81,103,27,172,130,
			211,85,26,247,180,192,243,222,64,41,53,50,145,248,248,175,37,26,6,23,247,38,215,60,12,224,37,72,252,110,191,133,
			250,194,105,65,126,190,205,157,70,182,43,213,227,29,48,91,244,180,48,185,73,45,240,46,42,194,209,138,144,167,176,251,
			5,9,183,120,111,17,150,231,234,35,43,38,218,69,214,247,137,46,10,86,223,226,40,227,145,163,34,116,143,218,24,252,
			0,58,186,136,136,100,35,58,60,248,144,104,54,224,142,42,163,248,7,122,63,79,161,23,244,79,110,41,89,20,132,253,
			23,171,88,250,109,240,254,182,253,17,58,219,22,3,62,11,232,199,139,120,127,186,138,161,200,60,252,132,0,115,117,128,
			230,82,149,106,117,192,139,135,79,33,220,253,120,45,140,77,140,150,83,23,139,164,74,210,114,160,1,58,4,160,77,54,
			161,6,247,135,193,114,213,227,202,102,35,227,110,241,34,62,167,198,102,249,18,214,197,252,83,185,23,96,130,25,65,157,
			229,78,182,196,141,242,52,78,66,39,227,189,125,6,97,227,7,251,254,141,94,102,202,26,108,126,178,49,254,131,250,242,
			169,128,235,57,11,4,182,158,254,139,217,3,251,176,188,3,9,91,74,56,159,243,244,76,50,131,221,11,248,88,77,24,
			34,245,29,12,200,85,78,150,25,254,68,194,110,157,92,246,200,56,24,107,119,133,178,151,251,252,165,40,229,55,254,79,
			41,211,193,28,152,205,236,65,219,94,154,178,156,151,100,153,118,1,143,20,96,62,191,101,40,217,54,233,75,43,227,77,
			186,44,37,93,7,166,77,149,235,15,79,68,53,168,150,35,204,100,126,214,38,135,90,158,80,21,53,158,85,91,96,129,
			210,148,40,131,17,243,213,180,21,134,96,68,74,162,21,233,247,250,169,4,104,180,207,138,23,94,71,43,17,126,195,20,
			94,6,197,72,40,252,149,135,248,172,15,182,102,123,149,33,104,128,200,24,114,173,176,177,42,50,72,59,209,182,140,134,
			109,246,242,169,6,47,27,87,35,146,233,25,191,217,44,205,234,68,179,38,120,24,249,152,241,30,228,26,67,210,117,4,
			163,56,65,246,137,246,154,132,88,154,254,174,69,127,151,1,102,210,80,164,170,241,181,54,192,85,98,203,58,244,99,3,
			252,40,101,214,228,33,108,18,169,9,100,221,33,216,214,102,252,22,193,148,33,184,4,96,80,144,201,23,144,89,61,21,
			77,193,74,62,241,168,204,105,181,245,192,17,145,15,75,174,145,172,79,36,91,69,75,46,178,150,44,67,173,54,120,22,
			75,156,53,115,1,45,167,113,255,199,174,68,197,241,1,54,24,194,209,128,227,166,103,111,141,96,67,16,144,94,129,40,
			200,87,97,248,188,3,51,155,108,247,116,34,88,137,216,91,51,92,156,46,84,232,115,182,105,187,97,100,157,170,103,44,
			169,39,113,184,128,173,112,181,24,241,103,16,233,198,37,164,42,34,140,36,156,73,132,83,114,132,118,216,162,165,144,191,
			81,33,82,61,63,183,49,248,91,82,132,202,124,214,16,111,10,122,98,246,16,92,126,34,121,197,129,77,115,14,129,150,
			27,96,215,139,77,240,83,62,170,213,133,158,182,67,117,88,227,88,193,220,33,222,15,173,53,157,110,80,185,120,171,195,
			218,116,40,58,167,244,107,240,192,131,208,65,133,242,215,102,200,162,230,181,125,121,21,192,178,54,231,206,50,7,99,71,
			234,196,217,86,189,63,65,171,140,45,208,23,241,226,86,107,80,85,52,76,156,126,109,57,196,142,8,28,1,175,34,90,
			164,110,91,243,134,38,198,209,119,84,196,105,150,206,249,128,167,195,198,51,124,43,130,175,33,131,36,96,178,147,106,104,
			107,30,113,12,100,43,70,66,183,193,136,147,80,101,205,168,229,209,182,132,88,75,35,87,224,237,64,47,59,54,77,191,
			61,232,37,66,167,223,1,61,171,123,244,163,66,145,123,238,142,132,92,47,237,192,175,163,119,66,199,235,105,101,246,58,
			201,206,96,121,58,135,60,209,46,68,52,67,127,203,129,86,126,148,70,164,227,215,125,1,84,122,180,172,66,170,93,89,
			67,233,111,16,81,111,147,64,137,221,8,177,145,14,80,11,110,195,234,237,81,243,0,251,207,238,46,165,38,161,219,131,
			0,115,200,78,173,53,163,123,146,120,190,42,21,227,84,62,82,226,4,254,158,68,187,73,68,171,106,89,74,188,23,88,
			175,9,24,116,141,15,59,221,165,33,243,69,72,67,20,25,139,199,53,170,180,247,80,188,128,211,160,95,226,42,11,11,
			251,111,12,248,50,43,223,232,65,184,175,96,142,168,99,131,2,203,83,60,150,251,85,140,165,62,195,168,26,95,27,226,
			3,4,146,78,241,117,36,242,219,182,209,112,26,161,248,6,186,190,37,108,18,34,117,20,105,195,21,132,76,36,27,190,
			124,223,28,194,222,149,51,192,207,212,178,43,191,105,124,11,19,40,207,187,188,153,44,103,115,254,254,118,6,131,205,10,
			137,249,14,97,214,213,49,204,29,137,251,46,166,93,13,199,78,118,18,245,189,44,10,75,6,137,250,126,166,44,140,119,
			137,249,65,166,44,95,244,147,42,149,184,31,102,112,242,188,89,226,126,148,41,140,25,33,81,63,206,54,44,206,240,39,
			232,92,61,67,75,43,237,167,25,100,48,32,172,184,1,63,203,179,177,39,192,158,110,251,231,121,54,42,204,47,138,216,
			168,112,191,44,96,163,66,253,170,128,141,10,101,228,217,168,48,213,34,54,42,92,173,136,141,10,87,47,96,163,66,137,
			60,27,21,166,183,144,141,10,217,40,100,163,66,54,33,245,106,8,74,115,202,132,2,73,65,138,12,176,5,152,48,11,
			168,114,102,88,31,27,42,161,101,97,61,98,193,178,142,62,148,131,70,66,218,98,179,133,148,159,116,77,179,44,155,237,
			33,50,114,156,33,94,38,192,53,206,197,216,110,97,33,97,241,131,110,21,110,217,62,24,135,106,106,41,120,231,219,195,
			160,37,203,1,167,117,181,182,143,108,241,98,84,0,179,8,123,194,120,27,33,244,77,105,177,134,38,150,59,253,102,192,
			187,137,33,24,228,91,2,65,38,48,153,187,237,126,12,234,58,44,30,63,180,213,1,195,0,42,232,187,112,114,26,196,
			100,43,127,86,6,68,181,141,246,47,112,218,188,201,186,16,134,26,10,196,6,44,101,254,107,204,162,234,126,139,93,175,
			228,215,210,191,97,155,40,7,86,59,67,180,182,253,45,44,197,232,14,76,97,22,191,3,207,163,87,73,194,90,147,159,
			167,138,201,126,207,61,162,94,53,200,97,247,229,149,80,156,165,35,159,131,128,179,47,173,253,90,251,73,81,53,90,242,
			25,4,125,185,183,63,166,110,54,56,137,56,90,82,31,0,32,25,19,45,184,117,68,192,3,49,22,210,139,238,216,211,
			250,32,112,186,215,106,235,139,244,131,81,37,24,204,124,107,33,155,219,33,108,29,144,37,44,212,123,178,216,148,241,255,
			48,148,120,8,200,93,155,63,74,187,61,142,17,73,25,214,76,235,79,24,41,26,20,214,16,79,200,192,255,25,21,213,
			144,209,59,100,192,253,101,72,46,138,226,236,112,157,172,234,81,89,127,205,20,84,163,117,166,99,255,141,161,28,149,217,
			51,131,232,92,228,239,176,131,212,101,68,253,228,236,80,88,7,106,83,160,25,63,254,212,139,205,118,143,228,213,229,64,
			180,135,17,81,87,114,9,101,12,234,195,209,152,152,58,125,42,119,4,56,156,197,197,199,115,71,162,169,49,182,223,100,
			135,14,46,232,168,84,13,146,162,149,209,40,107,64,203,134,128,67,57,31,77,212,91,231,170,9,159,17,26,250,164,162,
			176,229,97,198,158,65,188,247,163,218,112,204,80,124,86,153,62,249,76,6,18,239,7,30,75,116,51,177,21,62,96,180,
			163,155,176,233,51,80,38,59,14,217,101,200,50,103,160,76,119,124,42,59,237,125,196,52,217,9,169,236,180,0,0,25,
			186,19,145,93,81,46,233,3,215,147,144,93,97,46,105,186,147,165,209,158,106,133,126,120,204,68,167,20,112,36,205,66,
			38,59,53,149,87,20,235,32,67,116,90,1,59,10,242,58,29,121,229,179,72,87,254,140,132,23,157,206,178,207,132,246,
			212,30,60,63,107,136,253,140,252,62,249,70,141,220,198,62,27,6,124,236,162,202,15,215,194,47,225,28,214,100,60,57,
			217,36,94,56,191,171,199,105,252,115,135,176,135,230,241,91,138,231,97,108,186,14,187,193,213,12,11,47,29,144,136,159,
			15,69,172,202,70,198,82,229,105,123,226,23,128,64,69,3,45,36,184,16,218,146,125,216,115,168,139,120,173,132,99,156,
			26,53,139,175,91,93,12,208,128,169,94,108,229,198,92,130,230,66,13,203,213,145,108,215,165,0,194,80,212,129,151,129,
			7,178,177,58,248,114,204,130,1,46,9,64,177,93,129,129,140,123,211,185,147,128,43,135,248,78,130,87,231,202,93,53,
			36,119,126,105,68,94,61,196,59,101,204,166,138,89,115,236,107,48,185,97,131,23,31,215,130,113,250,169,0,67,175,67,
			93,234,78,45,100,87,48,105,35,144,14,184,30,139,162,60,56,122,36,154,180,160,184,1,21,76,147,40,204,141,200,147,
			61,125,83,224,155,192,11,13,140,123,136,254,205,60,135,36,64,154,124,7,111,65,59,148,11,24,31,73,220,138,54,202,
			159,183,65,200,228,145,133,60,194,128,82,78,14,25,212,11,22,158,127,199,144,116,232,174,203,163,141,170,51,120,39,114,
			229,143,154,81,37,91,34,184,11,150,128,124,198,3,27,248,119,163,38,201,39,79,223,247,160,155,83,176,250,189,67,236,
			27,18,136,251,164,209,162,40,239,31,82,135,2,160,121,32,73,22,49,232,193,164,48,144,63,132,102,36,159,254,195,67,
			236,23,35,105,31,65,17,0,63,58,164,182,234,253,199,64,63,0,127,103,233,247,250,248,16,31,143,178,119,83,84,234,
			19,96,133,130,69,103,48,128,63,57,196,183,145,228,56,132,71,187,51,240,212,144,58,62,106,153,11,197,211,252,97,12,
			242,199,51,24,106,234,254,255,179,244,123,110,102,67,52,222,11,213,151,132,114,235,241,185,33,246,223,214,246,194,6,159,
			199,176,142,162,252,83,143,193,219,144,10,81,75,186,23,128,173,139,18,236,139,67,124,51,166,133,203,8,216,74,126,137,
			107,102,241,128,123,25,77,101,55,240,122,15,233,173,120,11,253,21,12,98,237,236,74,173,160,33,186,175,34,59,63,128,
			153,205,135,72,175,65,28,234,70,3,147,30,95,160,120,29,92,135,57,242,198,80,180,185,169,206,121,235,105,23,141,55,
			121,76,243,240,245,160,92,229,123,2,25,32,175,194,223,30,226,195,208,24,8,190,189,147,33,100,174,190,139,17,35,185,
			170,78,83,195,106,213,18,239,113,51,35,43,62,129,191,207,10,132,180,74,10,234,127,64,224,181,149,133,159,66,124,136,
			124,228,91,27,209,201,44,35,254,129,4,42,104,97,10,241,207,216,0,146,71,209,18,250,47,20,27,223,159,141,193,31,
			177,213,236,56,117,245,253,49,91,91,145,145,88,209,48,159,64,66,210,152,79,135,248,152,54,29,81,66,126,47,2,247,
			20,138,20,156,233,6,149,193,161,33,62,128,77,147,71,200,97,52,39,70,146,164,68,136,197,176,194,115,133,232,20,75,
			208,43,242,20,190,214,20,136,203,64,11,136,145,33,172,90,138,146,49,205,232,16,187,164,121,22,78,144,220,207,134,164,
			143,29,9,113,111,184,192,252,55,152,18,56,125,109,135,108,114,50,47,255,51,196,87,48,140,32,228,13,12,11,183,141,
			131,246,127,121,200,198,146,5,12,111,218,125,62,196,126,103,109,195,156,48,204,62,15,166,244,156,199,2,113,34,65,166,
			167,32,209,29,76,147,93,37,224,208,182,20,209,76,78,80,56,154,229,232,104,180,208,89,154,80,211,34,218,132,68,30,
			98,193,211,109,25,34,232,233,68,32,157,106,181,210,150,165,20,221,99,166,168,49,191,225,140,176,28,209,111,53,38,125,
			128,222,176,218,61,209,179,211,84,208,242,104,86,62,97,211,176,156,21,8,181,110,1,138,22,178,254,138,195,240,63,80,
			119,170,128,91,105,24,199,19,57,98,189,77,43,19,201,6,114,103,192,232,119,66,54,112,241,90,99,205,196,141,78,220,
			30,91,5,61,3,119,116,129,59,110,32,93,117,24,182,101,190,14,48,134,162,248,98,200,123,181,226,46,72,150,171,171,
			35,107,34,240,226,26,175,129,38,224,65,123,143,223,177,173,137,53,135,225,63,50,24,41,71,188,126,196,240,181,144,52,
			180,141,86,232,171,90,77,26,198,181,144,184,148,164,27,214,70,158,46,158,36,238,151,206,154,235,12,171,27,86,113,218,
			201,195,184,120,75,16,236,2,40,216,186,72,6,23,160,168,110,83,226,2,16,147,153,157,115,140,10,8,166,130,205,58,
			101,158,205,235,129,205,121,18,173,207,215,39,138,245,180,196,65,136,219,103,33,105,44,118,198,156,70,232,185,229,104,233,
			24,167,186,158,178,219,128,200,231,141,65,94,32,120,27,82,178,53,241,206,188,27,109,186,243,229,106,150,43,199,227,155,
			146,156,41,1,86,34,213,232,73,103,215,25,204,96,229,29,11,192,204,97,246,81,105,71,223,27,209,55,191,101,141,85,
			89,4,220,120,24,119,251,226,42,90,240,43,160,161,75,118,103,216,114,155,179,192,211,84,77,200,132,172,164,196,112,54,
			139,46,188,46,203,198,215,156,97,220,111,130,139,49,199,79,5,201,38,195,124,211,202,240,122,67,41,96,93,104,11,137,
			137,106,203,92,84,157,189,143,228,119,247,48,187,13,123,42,249,166,195,124,227,205,108,73,255,16,190,82,61,140,57,205,
			9,235,86,187,162,181,121,179,180,56,38,149,218,28,37,52,195,184,70,91,96,52,141,67,155,108,25,235,58,95,94,46,
			149,183,144,209,150,121,16,95,3,142,107,73,67,231,115,67,173,164,156,173,134,229,14,146,244,171,98,167,229,97,190,143,
			5,63,39,246,89,70,67,226,138,64,88,184,26,219,166,117,44,2,249,192,178,110,145,125,182,29,170,30,171,232,200,123,
			58,47,253,219,67,182,211,104,93,85,239,48,140,133,158,162,79,147,37,220,216,145,136,230,20,19,229,20,207,78,80,146,
			105,154,1,126,124,130,172,226,157,9,55,35,26,137,105,26,109,32,236,194,18,171,68,58,162,250,2,107,9,175,173,195,
			118,133,64,72,241,137,64,187,177,246,182,228,232,170,164,4,116,247,97,132,187,136,80,186,106,220,3,5,134,46,86,178,
			61,188,248,4,112,207,52,235,97,8,70,44,221,43,61,122,108,167,210,128,253,65,38,52,150,32,95,204,8,95,95,132,
			216,27,8,229,177,90,149,58,172,78,18,97,181,191,132,206,247,133,232,177,157,30,209,111,98,27,13,206,236,95,134,250,
			5,127,51,240,175,32,31,182,29,51,136,175,98,80,82,79,208,240,81,197,96,115,5,229,96,201,136,69,244,215,136,98,
			147,12,174,234,240,244,6,127,106,28,147,8,75,40,239,142,175,15,203,91,133,32,142,56,249,13,130,77,209,189,110,117,
			213,243,205,44,146,151,79,114,111,199,223,119,24,247,61,120,77,189,31,100,191,137,137,206,193,1,206,254,195,188,39,72,
			195,10,39,224,78,203,129,91,211,1,195,124,71,192,180,6,248,90,176,119,224,112,228,41,13,179,19,39,98,134,105,31,
			4,121,202,2,35,231,97,188,222,199,238,249,7,15,227,254,9,80,135,12,115,0,128,192,115,254,128,42,72,91,12,133,
			252,113,88,94,203,66,179,255,52,140,208,12,180,90,252,51,253,88,1,63,80,254,95,134,249,102,135,255,87,12,109,39,
			114,27,34,192,223,88,73,121,242,110,92,232,255,125,152,247,186,125,184,178,186,135,34,91,44,129,8,112,216,48,162,18,
			180,168,94,88,189,28,62,204,94,114,158,168,8,236,117,139,35,144,139,114,135,166,210,142,68,215,199,165,36,240,163,184,
			110,180,140,58,26,10,37,38,0,228,24,158,23,112,145,139,247,96,143,77,229,144,192,143,131,240,120,188,30,82,215,210,
			250,69,211,164,21,204,241,195,188,130,179,76,126,43,6,110,206,125,39,96,70,194,21,85,222,0,97,71,6,207,107,159,
			56,204,247,49,249,26,215,73,104,45,220,228,193,196,147,135,217,17,72,109,137,170,190,59,133,101,59,244,217,6,112,98,
			240,169,200,58,166,173,193,21,135,160,167,241,156,33,216,239,25,140,39,208,233,104,177,223,52,221,51,134,249,214,14,46,
			89,6,103,14,115,108,2,234,114,124,157,5,177,211,227,25,123,6,28,202,229,30,242,217,24,198,73,84,99,29,117,206,
			176,188,196,150,248,116,99,115,243,92,130,174,159,112,220,175,36,238,184,156,234,60,232,55,205,151,15,254,87,216,21,135,
			203,213,249,168,108,221,113,188,11,208,61,164,23,16,89,77,134,20,187,16,77,243,91,28,7,64,45,62,47,66,249,68,
			148,134,94,140,201,23,30,2,150,25,240,30,139,93,49,3,31,151,109,107,209,170,245,18,244,97,221,193,162,60,162,82,
			158,173,172,97,28,233,217,36,239,98,73,196,101,96,145,237,224,108,57,143,188,28,156,173,154,124,33,244,10,200,37,213,
			73,125,250,87,14,243,181,96,124,152,126,112,21,58,51,238,181,24,124,53,11,175,168,75,151,117,251,26,52,21,39,45,
			49,196,191,150,89,221,52,173,186,39,212,81,44,181,248,58,20,214,18,118,228,34,116,253,176,188,248,144,64,110,128,124,
			177,43,188,227,180,110,28,142,2,20,72,228,77,195,124,93,134,132,58,184,153,173,36,110,19,79,36,193,45,192,249,77,
			172,138,110,29,102,31,254,160,121,219,176,244,6,106,6,97,245,118,158,99,200,16,134,35,88,69,221,71,191,99,88,69,
			124,112,90,254,157,168,75,149,150,238,88,232,215,44,195,108,221,53,204,87,217,105,189,106,133,12,190,27,234,54,243,174,
			158,178,97,101,56,94,255,30,214,160,158,131,40,42,236,69,65,130,112,47,207,199,106,211,64,119,215,247,105,5,80,19,
			247,113,35,157,118,196,129,251,81,42,238,104,68,128,7,134,57,224,67,88,147,54,138,101,180,220,7,229,164,167,172,11,
			163,70,131,190,229,212,57,215,135,134,101,40,30,21,103,209,104,248,15,35,67,156,172,17,144,79,216,30,97,205,38,234,
			143,50,75,88,204,200,52,32,147,19,163,238,49,148,166,226,27,226,146,27,130,227,177,186,142,178,84,154,239,9,104,86,
			154,229,92,227,73,112,222,37,250,186,241,20,138,66,252,157,144,76,14,60,10,249,52,138,106,134,193,51,195,242,66,93,
			63,182,85,95,196,7,182,57,177,190,120,73,85,162,221,144,30,182,28,52,224,229,97,190,254,39,132,245,202,48,199,53,
			97,205,235,180,95,133,84,73,39,24,105,131,179,107,204,107,178,235,113,59,249,117,100,77,2,82,169,123,97,235,13,169,
			171,168,68,82,43,111,130,47,209,244,194,251,161,111,13,243,218,26,15,166,64,169,188,141,206,213,61,54,226,8,9,134,
			233,81,5,109,241,14,6,155,78,17,33,222,69,15,231,157,61,34,244,123,82,19,232,160,247,161,115,56,56,62,226,221,
			231,115,252,0,227,46,250,168,200,107,181,100,80,124,200,250,57,2,27,180,70,128,154,250,136,149,99,228,97,251,49,106,
			25,207,3,218,140,243,201,48,47,55,4,226,32,36,211,238,167,195,236,133,77,11,68,121,61,128,68,96,17,207,141,53,
			199,161,209,53,4,182,73,38,41,200,240,176,12,158,226,136,197,172,169,73,170,151,12,179,83,63,155,106,190,17,214,132,
			55,2,222,250,125,6,60,152,13,175,62,10,2,76,73,8,61,211,71,182,227,192,103,144,20,151,62,66,87,78,61,255,
			6,64,197,96,224,132,19,22,79,156,48,211,176,106,77,236,8,38,1,223,224,13,194,241,230,4,170,92,19,19,137,108,
			106,49,25,49,106,41,194,174,87,140,5,103,150,38,244,250,197,104,14,70,182,76,57,158,117,207,178,132,175,148,20,190,
			79,104,208,223,192,244,151,235,76,68,211,77,195,52,150,47,111,109,66,212,51,111,133,49,242,194,1,182,88,113,140,188,
			152,168,103,222,74,68,182,65,49,25,73,149,104,24,222,202,68,49,189,35,69,207,188,85,198,166,153,191,42,209,76,43,
			166,241,67,171,55,244,86,35,130,174,98,2,151,230,16,199,119,240,16,189,175,168,87,47,111,159,242,6,96,178,53,136,
			108,78,49,25,233,143,90,136,121,26,14,232,184,7,191,102,121,5,114,180,61,243,214,250,95,168,231,79,34,234,13,139,
			169,105,89,139,56,51,222,218,229,98,138,183,123,214,41,23,67,219,12,60,49,185,83,79,210,124,229,88,235,118,234,37,
			166,232,153,55,165,156,6,86,60,215,100,42,209,204,24,131,166,103,222,122,229,205,105,208,2,97,253,14,226,96,90,100,
			186,77,43,231,152,233,209,196,233,120,98,131,242,129,16,145,244,204,219,144,136,54,46,225,60,85,55,228,37,49,200,167,
			19,225,172,146,102,9,178,250,18,202,74,121,185,53,14,40,132,146,103,148,103,135,60,122,18,202,153,229,146,20,75,16,
			138,150,41,54,34,234,217,99,181,71,146,110,76,164,155,140,143,180,103,222,172,14,196,178,170,112,27,39,171,223,164,234,
			204,38,226,45,202,101,53,201,87,79,52,135,18,109,57,142,118,166,115,216,164,131,212,10,175,110,54,60,211,239,42,151,
			125,56,1,18,143,231,150,75,147,133,99,24,34,233,238,160,49,101,35,218,32,219,148,200,186,199,209,138,40,77,79,121,
			127,69,13,141,72,55,35,210,249,255,3,131,162,116,155,151,11,144,82,191,58,245,22,229,212,154,156,71,212,91,150,55,
			183,128,186,103,222,188,242,174,80,244,243,59,168,24,73,209,51,111,171,177,105,230,111,61,54,205,86,219,148,107,25,195,
			234,51,44,115,219,114,185,144,4,61,243,182,43,47,167,101,120,53,195,39,123,107,251,114,217,161,206,234,33,99,21,67,
			160,182,67,57,115,104,205,41,108,179,182,99,39,246,25,22,117,229,78,157,154,205,20,61,243,118,46,215,208,70,232,153,
			174,217,192,97,240,46,229,84,85,211,111,73,191,55,241,133,114,22,6,136,32,237,237,90,206,66,73,208,51,111,183,114,
			133,73,102,28,28,97,204,150,216,189,124,130,171,58,158,49,184,71,57,107,24,223,51,111,207,177,40,230,239,85,62,41,
			25,86,216,250,98,185,29,73,235,137,189,59,76,89,174,233,153,193,151,58,112,194,180,217,83,225,203,229,37,52,194,214,
			87,202,177,3,198,224,87,203,203,119,157,129,186,240,190,86,222,58,250,28,252,122,57,131,131,48,8,218,223,32,252,70,
			101,201,93,222,156,166,5,72,216,250,102,249,204,230,215,4,246,246,228,46,115,191,248,86,7,171,199,168,211,26,33,244,
			191,221,65,117,203,59,4,223,233,80,28,73,151,114,148,7,229,119,203,135,134,229,96,87,194,177,197,247,58,88,89,142,
			225,126,191,156,71,56,169,19,63,40,151,100,25,154,164,30,218,141,31,150,103,130,103,229,252,31,149,215,19,49,36,153,
			230,199,29,70,3,214,79,63,41,55,107,164,48,224,252,6,132,63,237,160,115,90,208,23,173,159,117,152,209,16,150,0,
			175,101,226,41,212,232,235,231,68,223,243,63,208,247,204,251,69,185,166,137,38,54,211,177,127,89,78,229,122,162,102,226,
			222,78,32,126,85,222,158,186,233,7,166,101,25,229,82,71,20,190,67,214,101,181,188,27,35,146,158,121,181,14,227,141,
			132,161,183,93,47,215,250,52,92,60,129,160,87,212,46,209,97,20,208,170,215,172,90,162,183,131,69,169,72,122,230,53,
			198,65,52,191,57,14,162,173,204,113,16,109,189,160,131,224,88,162,85,37,217,234,176,6,51,48,123,32,54,176,215,182,
			202,7,112,68,214,111,184,78,232,249,173,114,142,123,34,32,237,99,151,143,222,38,101,224,116,90,35,53,154,129,91,62,
			240,234,70,187,135,105,246,41,207,131,38,241,160,233,149,231,193,111,17,212,61,163,229,119,208,18,160,113,240,244,68,176,
			24,46,43,81,204,88,15,15,112,132,139,225,130,86,171,133,150,60,148,232,167,239,85,173,208,38,3,78,176,63,179,248,
			245,98,190,1,22,182,132,241,155,197,236,92,213,39,240,239,183,248,104,56,118,3,255,126,7,34,90,228,59,134,247,123,
			250,185,172,131,120,146,19,70,112,191,39,117,241,7,187,144,209,61,31,190,60,130,91,55,19,137,110,102,57,29,124,131,
			64,182,212,72,238,30,145,36,91,154,16,211,147,151,27,244,171,61,113,25,203,16,77,165,152,38,185,254,179,236,136,186,
			168,89,64,164,42,177,28,145,76,45,38,33,244,242,35,240,188,201,96,87,24,225,93,116,121,229,53,10,58,128,151,108,
			87,36,196,180,44,34,186,170,4,130,149,136,96,131,162,148,113,129,43,19,197,172,78,89,196,148,171,140,200,216,177,140,
			81,222,205,171,142,192,17,79,250,145,98,227,105,53,124,87,113,2,39,191,87,167,239,85,57,77,228,54,190,6,65,214,
			92,104,242,250,77,158,95,179,255,198,72,20,44,66,3,174,53,130,80,166,201,89,112,18,148,125,210,8,223,20,151,21,
			22,107,163,144,160,169,121,180,172,51,146,58,17,133,211,90,79,21,241,137,26,98,242,8,226,72,58,85,71,158,194,174,
			59,130,141,223,176,209,136,221,55,80,63,126,135,1,94,6,77,33,125,102,166,130,172,134,141,208,150,60,158,92,111,4,
			190,104,210,33,60,186,57,0,248,250,81,255,69,49,205,16,126,106,26,242,148,119,115,53,232,6,35,236,184,106,215,253,
			38,13,134,13,233,107,110,226,90,46,221,55,217,33,88,119,72,247,43,42,156,239,116,136,132,89,225,16,53,109,39,76,
			220,239,43,35,25,255,150,129,170,3,143,247,96,6,26,94,179,162,67,227,153,35,56,250,192,251,14,70,228,192,177,17,
			132,37,58,61,86,209,120,123,45,135,239,125,134,13,244,224,198,224,116,221,115,156,248,64,122,22,114,181,98,119,134,217,
			104,19,151,142,224,238,115,64,238,219,66,44,140,240,155,64,96,181,19,103,91,224,152,186,202,111,66,49,51,187,64,80,
			228,206,133,91,157,56,209,158,75,4,155,21,16,32,43,121,115,210,176,229,165,115,185,113,77,105,186,33,226,9,165,114,
			237,231,96,20,124,70,175,174,62,147,170,218,148,40,55,241,9,204,94,77,73,225,172,10,253,36,9,203,104,15,17,111,
			211,217,109,74,198,98,149,14,26,122,210,205,70,34,119,170,172,51,71,191,211,226,43,22,155,67,219,248,28,148,180,174,
			101,46,6,93,178,10,35,71,204,45,208,135,100,102,52,16,70,82,134,129,218,18,32,68,63,247,73,214,132,0,233,60,
			72,31,186,131,239,76,4,78,67,96,36,205,31,193,217,131,176,122,77,177,21,126,202,200,80,91,163,199,212,29,163,32,
			28,20,117,103,27,57,50,211,209,171,183,29,225,96,133,94,216,216,110,36,137,109,85,119,164,203,131,23,240,9,200,246,
			35,184,75,68,67,11,236,216,1,101,244,98,223,219,219,113,132,15,84,201,220,179,229,251,85,65,211,114,236,157,32,57,
			3,56,64,179,40,183,157,71,226,103,59,92,199,114,118,65,86,50,100,153,101,125,1,58,166,206,7,8,236,94,178,43,
			234,60,96,90,44,198,124,121,101,55,214,151,30,217,116,82,119,209,47,190,208,228,239,142,198,196,241,196,149,123,217,30,
			172,62,66,92,250,245,36,108,79,110,158,235,56,246,94,35,60,69,193,173,88,4,95,4,152,108,40,75,236,61,34,227,
			117,35,32,50,31,67,113,152,220,47,141,176,115,68,13,113,142,52,240,151,65,140,251,107,41,232,87,160,81,170,142,124,
			174,3,195,248,171,168,116,11,103,216,134,197,97,145,43,161,109,98,122,250,26,234,135,184,51,124,74,129,245,192,215,71,
			112,185,199,144,170,32,19,208,246,27,168,49,28,247,241,241,205,17,14,133,195,195,19,62,238,223,26,145,177,42,201,92,
			36,137,249,246,8,130,125,246,59,180,172,113,190,131,100,181,176,198,87,195,191,139,134,146,86,115,236,239,177,104,112,140,
			252,239,143,240,173,54,207,115,130,31,176,144,25,13,233,165,201,177,246,127,56,18,135,149,242,13,203,168,255,8,250,145,
			20,27,199,149,114,13,59,10,50,255,227,17,25,123,187,183,87,6,4,9,56,245,79,70,16,105,176,209,248,41,154,202,
			93,192,118,152,105,245,253,108,132,227,63,26,118,24,248,63,31,225,16,93,3,102,175,23,154,193,47,80,99,202,25,129,
			216,253,95,226,163,30,182,92,48,233,87,35,50,120,61,63,15,38,67,233,27,168,94,64,148,240,87,34,174,87,89,25,
			54,29,25,77,204,175,141,68,55,95,229,16,70,215,215,71,248,233,1,55,210,63,158,49,32,70,56,66,62,241,37,12,
			122,81,34,41,174,90,141,148,97,99,132,227,112,138,38,215,150,204,190,133,194,50,81,100,45,100,83,9,47,34,44,224,
			142,161,110,26,48,107,205,62,70,26,54,46,79,129,45,22,190,241,120,68,187,194,76,108,161,7,90,120,144,192,30,225,
			16,80,28,54,157,170,47,123,166,33,44,151,126,109,62,14,237,35,109,19,25,158,107,31,200,92,219,72,28,141,188,145,
			66,15,82,246,186,130,73,149,128,100,232,121,190,8,201,151,30,228,167,17,4,68,182,113,66,70,28,199,141,216,184,244,
			1,220,106,102,205,22,130,197,80,130,205,100,194,233,71,119,247,122,218,252,48,128,246,81,245,22,24,131,96,63,201,44,
			188,242,20,121,27,98,207,101,69,241,249,120,230,229,218,46,140,113,178,186,216,32,141,248,240,235,17,28,247,25,158,249,
			27,116,129,101,84,17,43,61,248,45,250,170,225,144,122,18,254,239,192,254,166,41,95,25,112,156,224,247,60,141,89,8,
			20,214,116,196,190,72,95,243,140,234,126,0,91,166,10,247,185,63,119,104,205,241,92,130,28,48,34,35,159,246,137,246,
			129,224,50,141,93,156,172,51,225,65,104,148,48,168,160,131,145,83,61,172,245,29,2,129,161,133,196,31,164,34,53,188,
			190,63,2,66,18,248,39,228,218,235,12,114,202,63,163,192,42,191,38,66,163,248,47,156,90,8,239,175,178,234,30,214,
			141,127,67,193,150,185,144,172,183,191,179,105,67,243,180,131,16,133,254,161,172,225,249,197,138,195,184,152,125,66,179,126,
			248,136,60,164,55,104,0,114,17,71,32,209,66,56,82,241,231,145,172,105,17,216,169,233,52,142,146,34,139,144,198,78,
			253,104,228,17,244,120,98,240,24,30,6,50,246,246,177,32,233,35,65,53,200,42,56,14,36,22,226,108,28,175,134,45,
			162,12,159,48,194,103,235,174,235,64,145,180,66,255,68,86,42,172,73,78,26,225,231,155,104,16,57,246,201,248,109,57,
			85,196,185,57,101,132,79,192,81,229,192,57,117,132,125,147,72,111,85,197,105,35,252,206,9,2,79,157,206,221,58,96,
			216,103,48,30,251,149,65,243,76,230,145,83,119,206,226,38,35,246,229,217,248,229,128,135,231,128,157,28,65,33,12,12,
			251,220,17,25,143,208,238,59,143,121,110,177,179,164,115,62,74,192,13,88,225,93,192,133,9,131,164,246,66,30,120,38,
			77,115,23,141,200,192,100,214,197,35,28,169,16,161,30,235,78,227,146,17,190,109,228,84,229,28,104,139,75,9,48,69,
			6,41,198,181,13,82,219,118,192,17,18,16,149,240,178,17,60,27,149,65,66,199,183,25,125,57,230,130,44,154,20,122,
			253,138,162,116,209,61,46,211,187,114,132,175,32,219,226,42,72,147,37,26,87,3,128,232,155,215,112,239,209,143,230,181,
			35,252,62,142,139,145,232,57,215,161,218,252,213,15,105,50,237,235,49,20,124,163,87,208,248,238,167,217,248,134,17,249,
			242,85,226,67,41,143,251,235,55,242,124,133,3,118,115,33,199,107,160,41,191,134,74,220,52,34,239,60,135,52,143,37,
			208,155,49,158,91,2,49,235,120,121,105,120,173,91,50,32,170,239,173,168,14,194,103,33,172,56,164,240,54,150,181,208,
			133,242,187,93,86,205,226,40,17,125,194,187,131,167,80,56,11,27,13,121,167,9,253,69,146,104,153,181,187,184,211,109,
			26,153,119,143,112,40,111,139,154,100,221,3,130,1,146,125,75,220,203,125,203,67,235,190,17,126,216,7,215,11,241,2,
			201,253,144,6,246,169,10,171,226,1,224,228,117,13,40,154,7,153,141,176,145,31,130,62,35,171,84,190,239,32,45,160,
			135,1,235,35,123,215,74,96,143,160,210,117,60,11,36,191,31,5,119,52,63,89,135,70,171,37,30,67,190,70,157,214,
			208,143,227,23,251,31,61,49,18,71,248,100,204,147,60,235,10,196,89,143,174,193,61,69,160,117,116,55,70,126,117,143,
			38,233,222,167,53,12,174,235,192,103,177,93,129,111,210,51,35,137,175,36,153,66,45,8,236,179,35,137,59,36,2,188,
			56,65,232,199,47,80,62,7,25,106,17,139,159,71,213,122,169,47,219,47,128,167,253,136,110,239,137,23,121,130,18,158,
			76,254,18,4,143,172,202,151,65,219,64,204,245,87,192,232,133,14,149,35,94,229,65,4,247,198,215,208,117,42,150,9,
			207,77,175,51,159,77,139,87,230,134,251,6,143,77,52,228,77,238,83,24,72,254,91,172,135,225,241,194,88,82,45,254,
			59,224,38,6,85,195,164,37,115,116,175,250,221,17,229,178,168,222,24,122,143,190,39,45,48,27,62,2,31,135,11,23,
			226,222,55,110,227,191,63,194,161,101,200,138,11,168,171,63,24,97,223,176,192,51,97,43,53,63,28,193,125,77,27,81,
			42,241,160,94,5,94,160,131,255,96,113,164,145,71,38,202,63,81,51,131,166,160,208,255,215,136,122,191,5,23,134,77,
			229,73,238,125,52,194,143,100,56,136,132,246,177,108,58,233,204,79,144,12,145,153,68,240,41,107,60,233,162,181,8,115,
			33,49,222,100,151,91,68,104,31,98,9,115,241,144,10,47,69,97,40,13,179,200,115,32,152,222,74,219,240,236,197,168,
			180,26,174,180,206,94,50,194,241,198,234,28,185,219,240,70,100,169,212,235,163,82,111,226,178,220,103,35,28,21,80,230,
			193,247,196,254,61,34,3,164,242,57,157,99,184,255,225,153,131,180,75,67,252,151,21,52,46,231,187,193,231,40,220,54,
			104,170,169,144,26,183,68,224,142,170,218,8,57,81,250,251,16,96,45,196,182,144,193,14,240,218,3,2,20,120,163,40,
			28,193,26,125,127,84,122,187,145,53,18,32,117,208,116,216,247,6,177,131,195,209,248,214,81,18,175,180,127,84,6,4,
			108,203,207,1,124,186,8,30,197,159,131,163,114,65,202,215,252,171,180,86,173,183,145,137,81,111,10,190,199,161,22,253,
			11,71,249,182,27,45,124,100,76,161,95,211,247,178,131,61,158,209,254,13,234,83,243,194,160,214,220,23,192,182,211,211,
			118,246,27,229,176,174,129,216,127,148,195,37,146,20,53,195,64,28,128,47,50,15,16,216,205,110,28,56,202,90,163,97,
			214,200,202,177,235,7,141,114,0,35,219,8,140,131,81,41,155,196,138,205,110,188,167,115,200,40,207,80,148,143,225,255,
			1,197,224,137,48,241,71,20,67,115,191,251,119,197,20,146,222,67,71,57,194,5,113,158,87,11,36,36,135,141,178,66,
			160,97,119,248,40,71,143,91,232,120,71,140,34,104,251,160,56,18,53,170,155,252,46,65,203,61,106,148,141,67,123,129,
			115,244,40,194,7,71,110,96,36,185,45,17,28,3,90,204,180,94,157,100,236,88,124,241,179,222,88,29,29,55,202,35,
			203,180,143,31,85,15,255,40,119,80,99,224,4,102,93,205,19,3,164,28,73,213,158,136,186,146,129,79,106,233,36,174,
			63,217,215,39,3,214,50,105,66,247,78,193,79,121,171,242,84,52,218,181,66,172,182,79,67,190,190,124,41,200,198,75,
			113,226,116,230,177,237,4,103,176,112,132,48,38,206,28,141,3,179,147,185,237,158,133,79,158,179,56,56,193,217,163,234,
			81,26,94,3,157,35,115,55,112,169,245,220,81,126,8,174,214,119,30,42,43,43,194,139,161,243,233,123,18,31,179,152,
			189,52,197,168,215,135,188,250,5,163,28,222,119,160,162,34,174,93,8,206,33,190,186,113,209,40,191,252,150,132,127,38,
			171,200,190,152,75,166,30,192,221,221,190,75,80,97,190,232,109,92,138,126,32,203,236,50,84,96,128,214,106,151,115,99,
			56,102,254,21,72,4,251,199,115,72,124,174,28,229,203,47,65,160,250,53,184,74,38,113,234,87,163,33,189,130,223,135,
			186,6,245,96,237,123,45,247,58,105,72,235,186,209,228,94,46,201,212,245,163,216,183,129,206,146,27,2,141,134,127,195,
			40,108,182,54,118,150,130,230,141,40,118,129,176,172,54,2,242,223,196,165,80,91,110,70,7,96,129,193,87,163,240,56,
			212,45,40,161,225,56,190,184,149,135,12,73,174,35,119,126,121,100,221,198,85,161,206,243,111,71,137,174,112,56,32,176,
			220,41,187,131,91,19,109,60,208,92,127,231,40,187,143,42,128,156,10,238,26,141,3,183,170,189,40,236,11,222,61,202,
			186,25,66,193,119,179,31,30,229,187,125,84,141,71,192,187,58,95,15,120,116,148,239,206,135,162,42,159,161,123,140,191,
			113,15,93,62,11,248,56,18,57,112,0,127,98,84,89,234,188,142,124,18,89,4,56,34,18,79,141,242,37,105,187,30,
			138,167,25,42,12,98,255,51,220,22,117,129,205,50,97,17,63,203,163,6,81,213,159,67,111,46,48,188,231,81,90,67,
			238,18,145,238,12,94,24,149,198,44,205,136,245,23,71,249,197,37,39,32,227,168,33,216,67,249,21,176,31,145,42,32,
			74,175,142,242,3,120,86,124,211,224,53,150,124,82,110,49,228,117,130,204,201,108,254,164,55,139,162,231,81,131,230,27,
			163,169,45,80,87,136,232,234,214,155,132,153,146,96,234,166,242,123,229,100,111,161,71,235,82,218,44,68,54,2,225,219,
			163,60,197,202,224,19,166,251,206,40,63,231,200,55,98,223,69,173,97,84,69,117,124,111,52,117,111,4,222,184,81,16,
			59,170,233,71,132,221,36,187,87,169,182,213,228,154,51,108,85,163,157,202,143,33,26,90,12,61,164,251,4,92,76,130,
			246,1,244,41,247,12,94,132,228,123,45,0,45,98,41,3,40,116,25,48,68,128,105,178,180,196,241,52,224,125,74,60,
			67,38,188,97,244,156,140,63,205,27,171,139,233,123,114,82,14,194,169,68,227,122,201,40,98,138,36,213,210,113,159,159,
			49,113,194,132,67,103,76,152,176,122,38,176,224,97,51,240,14,175,30,235,239,112,130,172,145,141,16,120,4,146,102,130,
			177,30,9,194,108,188,193,163,100,126,178,201,12,57,26,100,236,95,75,246,175,175,200,142,73,128,216,216,147,192,99,1,
			244,121,211,48,1,30,151,0,147,228,199,19,112,253,108,136,196,104,87,195,233,19,39,16,126,90,46,202,161,70,112,226,
			12,245,42,182,196,35,252,145,36,58,105,70,244,42,118,22,115,50,97,214,75,61,108,93,209,95,140,62,133,208,83,180,
			247,171,83,200,83,81,223,244,51,213,41,252,105,200,59,245,26,117,10,125,58,161,167,22,54,23,15,15,158,129,196,197,
			141,5,250,76,84,44,155,184,215,115,90,8,0,123,22,33,39,167,67,61,70,168,179,81,104,46,219,8,123,14,114,205,
			70,231,141,144,231,18,114,221,148,16,68,131,206,23,231,149,182,5,243,238,249,229,109,1,250,130,210,196,100,40,185,23,
			150,39,6,250,34,116,173,38,175,73,215,94,12,113,201,69,206,212,196,229,18,176,41,105,237,66,179,177,208,104,72,178,
			75,9,149,9,150,169,130,95,184,73,16,207,203,136,104,70,9,81,82,225,203,137,106,102,150,167,249,204,174,32,178,141,
			74,201,146,236,174,36,186,217,197,236,144,87,36,146,152,179,87,17,233,172,194,44,21,101,92,248,213,168,99,58,114,45,
			162,78,100,99,69,92,67,100,27,118,38,185,22,76,207,234,5,162,172,176,13,71,82,116,221,140,212,75,242,49,158,205,
			250,254,40,190,98,30,121,61,165,155,158,174,98,46,140,238,13,24,144,29,240,55,130,199,186,58,247,220,56,122,42,222,
			93,136,122,252,38,48,174,19,93,204,212,155,137,114,227,72,4,242,116,73,91,110,65,209,229,132,113,97,183,34,195,212,
			44,84,82,199,219,50,114,208,161,146,183,131,52,145,131,78,213,188,35,45,50,29,42,122,39,40,115,125,197,61,152,233,
			221,187,136,114,110,122,152,104,81,153,123,179,209,192,239,78,51,95,203,55,91,218,61,80,72,218,172,105,240,189,102,25,
			213,228,94,168,133,168,208,20,230,62,232,56,125,66,213,145,247,35,203,164,66,41,220,3,132,235,202,75,69,182,106,10,
			254,32,168,11,250,39,195,33,5,126,8,3,48,129,170,165,124,78,99,61,28,9,176,82,105,101,116,143,128,78,43,188,
			140,238,81,104,192,226,98,31,195,92,26,49,80,71,60,14,22,149,228,253,68,90,163,234,168,39,163,206,42,168,250,83,
			178,44,57,179,232,136,167,145,72,211,38,58,238,153,4,199,118,133,142,123,22,56,205,230,208,113,207,37,184,92,158,207,
			167,249,17,120,252,210,38,163,94,200,52,91,199,189,152,158,140,177,27,140,237,122,137,124,41,51,227,166,177,47,151,76,
			52,170,86,178,155,94,41,157,66,82,100,175,102,122,211,224,203,242,76,253,90,170,55,53,196,235,217,222,212,112,111,100,
			122,83,67,189,153,46,74,87,212,111,101,114,212,113,111,71,147,181,50,195,120,67,152,9,222,33,204,164,168,130,26,252,
			93,20,164,91,110,9,234,61,100,150,84,79,195,188,143,73,168,32,179,216,148,249,0,147,73,17,1,110,157,242,29,75,
			195,250,16,19,213,24,52,113,180,146,232,162,44,229,253,15,74,183,229,184,210,197,119,104,41,213,63,97,229,164,83,233,
			130,249,47,168,240,114,180,158,247,71,144,168,98,142,201,246,15,24,150,245,49,138,43,154,166,165,101,240,9,208,89,155,
			61,65,127,42,59,75,142,87,45,255,69,4,223,32,111,108,177,127,131,156,135,135,48,23,100,37,57,53,27,164,198,194,
			48,100,73,69,93,202,190,24,176,24,51,101,161,213,24,243,85,14,139,37,133,51,85,17,229,72,52,245,228,45,198,12,
			229,40,81,118,23,22,174,186,37,67,255,25,209,111,90,92,135,226,4,255,70,130,226,170,20,39,248,79,122,241,4,219,
			167,71,95,109,252,55,179,120,202,17,124,158,49,151,115,4,31,205,97,251,95,38,223,39,52,234,94,24,107,192,143,9,
			55,53,233,215,12,246,19,194,206,72,219,110,13,249,12,173,110,157,125,74,84,27,116,164,88,52,167,72,190,34,71,57,
			215,10,253,161,57,88,1,194,212,204,116,206,240,28,104,30,32,178,189,176,56,198,100,217,189,100,14,88,154,206,76,31,
			117,35,115,192,177,76,158,58,193,104,76,80,50,241,125,134,6,21,85,55,214,84,255,38,138,13,11,235,29,147,252,103,
			14,6,66,121,53,99,194,255,206,129,120,119,168,111,76,249,121,81,169,233,137,107,66,215,132,9,91,164,23,191,41,105,
			41,28,54,19,41,209,182,99,38,42,22,240,165,186,82,67,46,111,210,100,232,151,238,74,15,185,49,19,44,211,149,30,
			114,99,38,88,182,43,109,171,231,90,19,177,115,57,34,156,62,70,231,44,223,149,86,219,133,68,43,116,165,44,249,212,
			58,58,158,131,100,229,86,236,210,86,38,157,8,87,234,210,76,3,221,170,89,185,43,53,253,235,168,85,186,82,202,70,
			213,149,95,37,99,252,170,93,105,101,147,35,88,45,157,129,202,59,193,175,158,201,32,71,176,6,17,204,41,230,125,142,
			118,77,162,157,81,166,124,3,249,22,131,104,173,165,243,65,55,90,38,165,249,160,163,214,38,212,230,229,155,52,133,82,
			179,14,165,217,102,172,52,197,67,96,114,87,122,38,43,30,62,200,101,93,162,220,97,92,148,133,117,156,66,201,119,251,
			31,146,23,87,119,106,87,106,59,142,83,246,32,209,122,93,233,237,184,4,179,126,161,96,37,248,105,197,130,149,16,108,
			128,97,84,100,152,202,56,184,242,221,137,13,11,5,34,75,53,189,43,181,222,75,143,196,28,117,133,168,231,150,234,232,
			28,249,12,168,4,221,0,131,91,108,198,224,154,153,208,72,96,76,147,216,108,27,117,21,25,114,241,214,218,198,9,90,
			51,228,98,244,172,174,34,59,47,70,207,78,208,69,153,207,129,56,230,202,70,45,179,37,110,146,80,106,229,20,181,185,
			11,148,185,26,21,181,124,110,66,89,88,122,2,236,238,226,165,184,47,189,11,213,249,67,20,49,165,210,107,72,71,226,
			8,179,41,168,179,192,132,60,147,79,15,186,61,87,223,152,58,219,230,205,64,158,99,68,76,158,205,104,115,144,151,215,
			37,155,209,22,29,27,154,205,124,203,206,117,201,114,113,94,66,174,241,187,180,46,243,137,124,102,178,25,155,28,132,212,
			225,239,128,120,97,60,88,182,34,178,205,50,20,186,226,105,98,11,47,244,216,137,86,41,231,173,97,121,140,51,73,172,
			182,183,129,166,206,214,36,153,219,244,52,241,144,223,182,160,160,146,52,73,249,219,81,162,13,165,15,61,162,159,81,235,
			107,149,196,168,229,220,182,135,250,97,223,251,152,34,109,28,51,213,14,80,133,216,98,45,193,239,136,130,224,129,65,26,
			166,132,100,39,244,65,148,69,6,167,220,122,76,59,244,119,198,72,234,80,82,228,170,24,250,187,16,229,38,169,199,114,
			212,246,47,199,109,202,36,251,2,27,108,73,144,254,20,109,65,49,187,118,229,86,9,202,229,93,95,3,236,214,149,90,
			37,20,80,236,222,85,180,214,226,112,191,21,246,232,200,206,15,123,68,134,95,25,125,54,179,61,145,160,24,165,210,101,
			114,219,43,99,220,101,216,42,195,14,127,49,109,37,22,210,236,221,85,116,24,130,0,158,97,163,89,25,252,82,87,209,
			2,54,66,235,11,241,47,119,105,155,178,197,134,171,78,254,149,46,181,216,142,246,160,85,1,241,70,115,180,145,249,213,
			52,33,163,52,82,62,32,101,194,175,73,251,84,219,128,150,196,241,46,115,68,248,117,157,144,17,9,93,244,68,7,19,
			126,163,75,237,161,22,213,49,41,248,155,224,81,89,193,169,12,191,5,107,187,188,45,122,179,191,221,197,219,251,133,149,
			212,27,243,157,174,49,78,22,248,230,3,126,126,183,107,172,253,253,152,244,123,93,218,230,80,201,238,190,34,253,62,6,
			240,152,71,1,138,248,7,176,177,199,58,6,81,180,63,68,198,99,30,71,40,226,31,201,46,232,116,198,160,40,127,140,
			42,140,117,30,161,104,127,50,86,117,137,97,145,61,246,211,49,171,171,17,255,12,196,99,241,55,34,254,121,87,106,135,
			107,44,242,95,116,21,30,42,100,216,22,81,255,50,99,100,142,65,254,43,112,100,12,62,71,180,6,42,50,38,167,35,
			234,42,81,239,53,6,175,179,154,176,184,178,53,228,52,70,29,171,130,39,202,49,186,160,78,57,237,61,86,159,202,74,
			141,201,66,65,121,125,121,76,110,168,122,141,217,219,189,148,219,158,227,226,214,24,213,111,80,70,95,26,83,90,198,217,
			198,38,106,53,62,126,117,174,187,137,90,141,45,149,227,147,135,5,48,8,199,39,89,236,21,72,171,252,62,216,105,99,
			114,133,231,207,36,145,149,89,186,143,167,160,22,165,217,114,236,134,102,74,178,33,151,227,147,240,49,37,201,65,94,227,
			149,203,49,198,139,27,111,95,21,108,117,69,97,23,97,22,236,131,137,85,236,19,26,136,152,136,171,155,57,1,227,132,
			30,155,145,166,85,231,147,119,15,129,8,75,40,253,174,130,173,123,73,154,78,31,116,21,109,221,23,81,134,93,69,110,
			17,146,210,176,90,14,45,75,184,5,52,87,244,75,59,203,247,123,130,166,145,23,75,78,57,16,153,232,69,102,86,156,
			118,16,179,126,3,113,95,133,167,103,150,173,71,27,54,171,31,86,125,17,148,80,44,132,49,95,86,158,76,249,107,144,
			240,13,136,36,155,76,138,223,16,201,106,82,79,155,190,220,159,249,45,129,86,87,83,78,4,251,29,193,86,193,252,22,
			1,126,143,116,114,230,136,64,19,150,76,156,208,83,236,139,197,102,97,28,164,147,49,144,146,137,148,162,187,96,195,177,
			140,126,41,162,223,172,196,155,171,36,201,210,168,84,225,246,103,89,138,101,80,72,97,51,16,248,59,108,21,36,89,150,
			146,108,90,208,142,210,4,203,81,130,146,77,192,210,52,203,163,94,133,45,41,77,178,66,105,143,200,235,196,249,20,43,
			150,244,72,25,253,74,229,61,82,150,100,229,210,30,41,75,177,6,165,216,162,131,96,209,40,53,17,26,217,227,187,55,
			42,209,154,168,89,169,108,21,38,89,139,146,108,217,73,188,10,83,77,66,237,58,72,88,97,162,181,41,209,220,194,38,
			21,146,175,67,228,155,20,52,166,144,120,50,250,176,184,25,133,244,235,162,46,133,13,40,36,159,130,246,170,55,93,199,
			221,128,169,232,13,153,104,188,205,88,15,189,33,147,252,15,141,89,63,169,221,248,155,52,141,18,109,211,161,73,82,48,
			11,147,110,64,73,183,42,109,88,135,132,27,82,194,109,59,53,175,67,218,233,73,125,59,12,164,194,164,21,112,53,117,
			138,194,131,173,96,171,222,150,191,253,166,209,27,204,128,190,210,14,124,198,147,102,38,165,153,151,62,143,25,79,178,141,
			80,193,212,17,210,120,82,109,60,238,102,41,101,201,169,102,141,179,89,122,154,217,227,111,150,158,108,206,184,155,165,167,
			218,4,21,28,87,179,170,252,74,6,210,116,65,191,142,163,81,73,138,185,24,51,227,107,82,146,168,27,85,27,87,131,
			146,52,155,166,21,121,135,52,82,184,57,81,143,174,200,199,151,100,179,140,34,31,95,170,205,211,138,124,124,137,182,160,
			68,91,143,171,73,28,209,95,75,185,37,165,156,63,142,118,101,211,205,195,224,31,95,227,178,73,231,163,178,227,106,97,
			54,229,86,148,82,59,100,147,23,34,122,16,109,95,166,218,154,240,83,163,198,228,176,219,16,86,63,130,203,17,108,139,
			236,147,138,229,240,219,45,153,168,187,109,202,199,233,85,133,183,39,92,236,182,153,194,236,64,24,221,109,51,133,220,17,
			89,38,69,166,112,59,17,78,243,240,143,158,166,139,208,59,47,153,152,120,248,103,145,187,160,41,90,161,89,252,23,150,
			76,212,61,252,179,232,93,151,76,212,15,35,101,23,100,137,118,91,194,15,217,119,34,217,125,73,244,120,116,39,170,61,
			150,168,231,238,59,17,237,9,6,103,171,36,247,168,9,51,41,93,15,134,127,145,224,147,115,133,51,106,239,37,19,117,
			15,60,13,243,173,52,211,125,195,246,123,16,175,166,87,162,191,173,51,61,139,252,78,134,233,89,252,119,211,76,207,162,
			191,183,36,138,252,46,207,169,178,248,239,39,120,62,173,202,226,127,0,188,118,86,150,197,255,48,193,23,230,255,163,104,
			116,69,71,36,25,252,143,101,219,213,219,191,25,228,175,8,57,123,0,175,230,168,97,156,240,208,74,118,158,153,212,32,
			210,141,117,210,136,159,89,194,42,17,206,209,9,53,222,102,105,107,217,242,19,62,103,73,235,217,108,53,158,103,105,69,
			49,45,243,55,75,219,155,165,213,250,34,75,219,40,166,45,172,67,19,195,163,152,181,9,145,137,193,88,196,212,132,100,
			1,6,99,9,59,19,170,190,108,105,9,35,19,34,43,155,149,198,194,132,170,85,76,197,12,73,168,236,44,149,198,182,
			132,202,41,166,202,148,232,102,217,154,176,74,25,52,9,237,62,68,59,171,136,99,57,74,15,235,158,18,198,229,136,253,
			108,21,18,254,229,104,131,108,198,26,27,115,196,97,49,49,243,41,71,220,159,37,214,152,154,35,30,40,38,46,174,198,
			96,249,64,151,106,52,33,109,151,13,244,44,225,194,14,3,61,75,251,235,242,129,158,37,253,77,135,129,158,165,253,109,
			135,129,158,165,253,93,135,129,158,165,253,125,135,129,158,165,221,23,75,230,98,214,106,150,80,66,191,31,209,119,21,241,
			183,144,122,127,108,15,149,48,185,48,193,1,217,234,36,156,46,164,63,48,91,128,198,238,194,4,7,21,39,96,62,22,
			38,56,56,155,64,99,124,97,130,67,138,19,148,87,233,80,216,136,121,67,58,89,185,30,182,100,98,226,238,158,71,31,
			190,100,162,114,244,45,163,56,98,137,22,81,178,136,224,200,244,106,75,247,130,135,81,140,184,113,185,52,71,233,171,173,
			113,165,56,58,179,218,26,87,162,99,210,171,173,113,165,57,22,138,187,112,63,35,138,129,137,93,219,227,136,106,122,193,
			214,133,78,115,60,209,204,44,222,165,208,201,78,64,129,133,27,18,58,213,137,48,118,52,187,79,46,48,48,241,5,28,
			234,240,36,20,86,134,199,133,88,142,55,231,159,140,217,178,67,54,28,100,244,20,212,168,19,17,231,117,42,81,105,119,
			252,164,131,12,94,83,172,115,240,159,152,213,167,65,171,234,83,183,244,164,201,19,158,158,54,226,249,210,99,142,232,140,
			140,133,94,76,117,102,186,19,165,11,80,142,234,44,180,64,203,75,57,19,229,232,206,6,111,147,220,202,200,206,201,244,
			119,73,169,231,166,55,49,17,177,172,39,144,193,10,65,76,54,92,138,252,188,204,190,228,88,244,231,131,94,91,115,122,
			142,29,116,162,191,0,42,71,95,101,142,149,224,66,72,162,62,148,50,210,113,17,216,80,134,79,36,241,82,204,139,146,
			32,246,249,138,245,20,60,190,18,109,124,25,54,38,50,164,101,126,104,137,194,188,28,226,84,178,73,200,190,82,240,172,
			188,34,173,221,164,231,168,164,148,190,14,87,34,23,188,62,129,23,166,226,245,110,70,63,92,5,99,54,71,148,82,15,
			87,67,34,115,36,217,234,93,83,88,90,70,57,92,139,93,131,156,127,96,228,48,112,93,130,213,156,13,35,236,245,192,
			230,188,40,35,236,13,9,182,32,231,91,49,144,11,221,116,51,21,188,13,150,106,177,135,110,134,242,222,83,103,77,152,
			176,138,122,234,136,91,123,26,0,82,122,36,224,116,2,204,208,1,233,99,83,245,90,221,25,68,53,55,69,133,119,241,
			12,147,3,27,170,252,249,92,65,98,207,36,242,245,245,236,52,103,253,94,211,178,206,34,252,84,29,31,59,92,3,123,
			54,97,103,235,88,112,219,209,156,64,155,6,41,110,38,61,7,245,210,73,67,126,79,38,114,166,209,61,252,64,126,110,
			49,121,236,43,164,57,249,129,252,60,34,223,88,39,79,251,162,38,213,56,159,8,215,202,179,225,2,128,21,215,52,240,
			133,4,94,93,82,195,131,148,39,200,139,0,147,164,49,236,98,130,77,145,116,49,127,98,228,37,64,202,4,121,228,165,
			132,156,36,83,34,152,146,101,9,203,105,120,70,235,50,192,101,162,20,252,114,130,175,39,233,245,199,233,162,217,251,10,
			160,101,178,34,244,149,132,174,228,83,167,143,50,175,2,81,62,143,52,209,213,68,180,129,226,12,207,2,185,178,174,1,
			133,226,83,49,197,181,68,177,81,97,30,233,178,174,3,93,97,78,105,186,235,137,110,90,97,126,242,5,108,239,6,16,
			20,102,164,8,110,76,114,192,248,204,87,249,166,36,135,98,130,155,137,96,102,81,14,233,170,222,2,178,162,124,210,100,
			183,38,245,225,57,52,87,220,109,73,125,138,9,110,79,234,147,38,72,23,116,71,82,159,78,100,119,66,91,20,229,166,
			248,119,23,240,69,217,40,252,221,132,95,53,117,41,225,30,64,20,35,36,228,94,130,108,154,130,148,105,48,133,190,143,
			18,44,15,47,2,209,22,247,227,183,229,44,196,195,135,15,36,10,84,122,148,62,136,178,212,245,27,9,121,8,218,77,
			15,51,159,210,110,15,19,118,5,60,65,236,83,206,143,36,250,89,38,120,20,109,213,211,42,167,75,171,87,86,242,49,
			116,141,142,143,28,61,35,130,199,179,4,106,50,142,9,158,200,18,72,29,152,16,60,9,245,155,39,144,5,241,133,72,
			132,156,98,210,167,136,180,71,39,5,3,241,32,188,166,134,211,41,158,158,165,238,91,107,5,170,166,63,51,43,186,111,
			157,199,61,75,184,213,76,187,31,62,35,234,253,230,231,8,180,118,4,210,59,228,249,89,124,39,58,110,84,17,205,11,
			160,209,56,83,68,243,226,44,190,209,158,111,72,226,251,237,213,94,154,197,161,83,10,24,164,83,189,12,42,125,50,42,
			164,122,5,5,106,83,80,33,209,171,68,180,166,214,58,89,215,215,0,213,218,35,161,175,39,106,93,47,60,26,119,111,
			64,78,117,180,156,54,21,246,205,4,171,79,170,10,251,150,62,99,184,185,172,223,78,70,137,236,173,119,178,22,65,70,
			6,222,133,84,166,12,144,140,32,188,215,97,166,143,167,229,132,252,125,34,239,78,149,167,49,160,128,254,3,162,239,202,
			155,65,201,205,118,211,167,201,85,70,242,178,197,135,201,220,81,52,33,42,99,193,9,254,129,92,203,41,50,60,248,231,
			44,118,101,47,163,206,114,228,95,224,177,60,84,151,221,253,17,1,102,229,219,80,32,194,31,23,83,22,200,222,39,80,
			6,101,148,105,89,254,180,152,180,104,112,44,74,202,207,43,154,84,249,67,197,148,5,53,29,78,138,207,83,166,139,95,
			92,76,90,84,211,37,179,56,66,64,78,254,71,102,241,37,203,188,228,143,34,65,193,112,250,44,49,189,162,179,116,102,
			210,191,19,83,45,5,255,15,134,95,154,94,51,33,255,155,12,206,2,236,231,179,248,242,120,126,196,239,187,152,22,163,
			69,51,173,233,59,126,13,175,44,103,18,236,71,9,230,230,77,187,50,242,253,241,232,83,161,173,84,150,226,128,164,70,
			105,147,165,44,193,129,120,121,71,205,215,124,50,98,181,83,23,60,14,34,252,148,104,151,26,103,252,122,63,31,76,200,
			53,115,208,67,8,186,150,220,143,209,193,127,32,240,186,218,174,160,142,251,35,222,32,18,131,129,39,90,194,42,34,248,
			19,24,151,18,177,18,115,67,98,255,188,152,223,52,198,179,214,1,70,116,240,23,174,41,211,17,59,218,170,99,255,90,
			218,120,137,255,27,90,34,207,139,244,129,248,119,2,79,82,60,209,225,135,102,216,33,161,135,101,217,33,193,135,23,178,
			67,226,142,40,103,135,36,56,146,8,54,239,188,126,228,172,245,198,28,133,23,199,58,167,73,141,152,163,241,14,146,162,
			148,76,60,6,45,209,152,168,76,187,99,33,34,185,66,21,242,56,60,30,85,48,178,20,250,120,60,79,58,134,29,153,
			207,244,4,140,139,49,82,169,210,20,254,196,197,28,141,95,210,202,214,156,148,105,141,50,72,79,46,108,141,66,158,82,
			210,26,133,62,21,163,79,89,214,18,82,38,166,10,125,26,37,88,131,119,118,241,106,66,159,92,7,159,14,49,146,82,
			167,65,207,64,117,85,161,26,248,76,228,192,50,167,1,207,34,224,58,92,251,44,230,108,194,76,214,164,78,67,157,131,
			193,144,21,58,13,127,238,98,14,119,108,242,3,25,129,233,137,243,248,161,44,117,150,205,144,243,23,115,64,116,201,24,
			9,186,96,49,63,19,2,231,32,9,184,16,169,148,211,137,132,92,132,150,233,190,40,18,124,49,6,72,182,62,10,119,
			9,250,193,82,251,16,216,122,114,29,188,51,99,32,232,189,233,247,93,138,166,168,122,20,225,47,195,147,143,92,169,34,
			236,229,200,92,22,87,132,190,2,111,145,105,213,45,162,185,18,15,5,102,235,94,68,120,21,106,162,120,104,14,102,177,
			87,163,38,17,63,243,232,107,88,84,153,183,121,228,181,200,89,49,45,143,189,14,207,227,233,60,207,147,92,143,151,41,
			115,252,207,211,221,0,102,203,38,8,217,144,52,254,70,40,51,213,136,66,130,155,120,80,161,25,133,232,155,23,199,71,
			9,133,248,91,240,238,155,214,148,66,162,91,209,94,89,73,25,54,72,174,117,235,209,160,36,149,112,27,250,53,242,178,
			46,161,185,29,28,47,67,222,129,151,249,10,51,112,77,155,31,18,96,178,59,241,196,159,146,93,188,205,150,207,232,46,
			84,54,18,223,98,146,187,49,56,74,112,247,224,73,199,162,228,169,106,220,75,84,155,120,66,174,211,10,170,147,34,190,
			79,171,51,164,56,95,232,253,160,208,228,60,79,241,0,40,52,97,206,83,60,8,73,73,228,44,79,240,16,100,90,71,
			165,42,249,176,214,129,82,8,242,57,60,2,214,234,114,146,39,121,20,114,159,147,167,60,221,99,139,227,99,167,52,73,
			170,82,143,163,82,74,240,6,132,85,200,153,39,64,35,115,42,165,121,114,113,124,96,150,161,73,21,247,20,166,131,40,
			240,81,100,227,61,13,182,197,219,244,89,236,51,80,218,17,80,206,247,207,66,186,114,9,36,238,57,198,33,38,115,84,
			1,101,83,80,233,175,194,48,146,75,40,245,54,130,90,78,39,240,182,224,23,149,212,130,154,237,43,134,203,167,151,36,
			248,141,132,220,13,61,196,108,145,240,55,19,114,249,68,159,4,191,133,54,75,176,23,87,243,109,158,68,37,45,98,241,
			75,232,59,185,10,74,248,187,185,10,74,248,123,217,10,74,240,251,185,10,74,248,7,217,10,74,240,71,168,139,146,148,
			228,182,212,199,19,16,96,74,245,176,124,0,193,175,225,29,84,207,159,56,39,94,13,17,190,46,98,196,82,132,88,77,
			37,81,160,165,231,196,139,147,52,237,50,160,85,125,163,64,203,18,104,114,252,218,33,188,0,155,2,166,140,225,245,45,
			135,32,94,1,45,16,220,38,191,68,231,168,104,243,168,233,242,132,91,41,48,92,126,95,164,95,172,64,159,43,24,166,
			199,225,253,87,196,71,244,110,197,74,244,177,178,122,84,16,47,4,174,172,125,35,46,245,42,244,189,74,191,89,11,28,
			140,46,2,172,10,192,128,39,99,122,3,176,26,1,214,210,151,90,174,176,107,166,181,58,129,151,147,63,215,0,133,190,
			82,148,224,53,9,188,162,108,154,109,86,215,194,151,228,19,125,77,66,253,147,166,174,77,159,107,100,219,191,14,128,173,
			144,172,11,215,138,34,237,15,78,6,191,36,101,22,181,46,218,141,16,253,78,80,25,156,2,86,71,190,14,18,52,21,
			221,226,132,1,182,55,82,22,216,122,132,88,51,103,92,173,15,168,140,75,139,151,11,132,132,78,67,167,72,218,28,110,
			3,240,214,162,218,216,242,123,195,57,136,201,146,62,0,213,208,211,83,245,209,16,21,66,172,74,54,105,128,39,107,24,
			50,3,16,126,175,16,65,88,141,126,179,62,19,225,200,120,118,192,91,85,120,174,162,39,51,191,110,132,136,102,76,193,
			12,112,236,44,193,198,68,160,244,87,39,178,89,136,23,199,4,53,43,172,102,177,179,193,15,217,173,169,185,10,149,157,
			3,156,108,118,14,183,9,58,203,119,169,155,105,1,220,197,140,10,224,252,90,137,25,146,232,176,185,144,175,72,229,37,
			224,110,136,130,222,9,137,106,222,52,169,149,194,37,201,122,8,55,41,46,37,73,179,25,218,169,122,54,143,221,28,61,
			144,210,235,91,32,159,76,239,2,190,101,34,121,17,147,230,113,79,107,53,141,16,243,161,111,10,173,163,173,8,51,165,
			108,158,219,26,209,238,58,204,112,219,128,51,197,243,245,182,136,64,151,78,138,51,53,60,215,134,23,153,18,194,237,136,
			112,110,209,92,90,76,190,61,184,87,58,85,238,128,214,80,133,2,40,236,8,29,53,117,71,32,203,164,120,39,212,87,
			103,93,25,225,206,136,131,167,102,227,18,146,93,16,84,143,217,34,2,131,159,5,82,167,245,118,212,127,255,175,178,171,
			12,115,228,70,162,187,23,102,230,108,118,98,39,153,164,119,39,176,225,187,92,152,153,153,218,118,123,198,187,182,219,113,
			219,3,27,102,102,188,48,51,51,231,152,153,153,153,113,142,47,87,175,196,234,110,219,243,125,243,99,172,122,85,82,75,
			165,82,137,74,213,122,220,198,3,132,187,25,163,174,146,118,55,182,91,37,237,65,73,155,201,202,81,18,61,213,81,208,
			61,135,245,142,67,197,49,28,110,221,162,174,246,34,232,112,246,135,232,70,86,95,180,55,140,106,210,140,39,170,245,112,
			81,180,15,186,81,71,173,37,85,227,122,13,15,80,105,242,190,198,116,145,145,29,111,99,40,81,180,253,136,182,140,236,
			142,251,67,213,165,207,39,82,14,224,238,148,109,30,14,36,218,230,226,43,82,197,165,255,105,232,198,11,14,18,124,16,
			129,183,180,149,170,63,203,193,60,82,176,89,196,160,112,8,122,140,215,235,68,189,30,138,78,145,58,249,96,56,15,67,
			19,56,107,228,156,175,215,129,153,237,240,97,142,210,209,26,0,122,196,176,183,239,145,137,58,114,216,219,67,201,68,29,
			53,172,119,45,207,232,226,173,31,106,33,148,156,28,163,102,216,32,125,57,122,88,239,90,102,3,142,33,192,92,1,136,
			38,203,120,53,47,141,57,118,88,239,69,170,213,23,14,45,36,139,50,121,28,70,22,217,70,190,12,241,106,237,241,236,
			17,240,119,216,113,113,79,128,65,148,206,190,157,126,34,224,66,160,157,124,18,37,111,163,166,22,188,7,208,233,182,155,
			124,32,163,209,8,233,3,227,78,70,233,79,54,102,73,114,245,132,159,98,50,145,23,231,7,201,228,84,147,137,228,234,
			9,63,205,104,53,251,169,3,148,235,116,151,101,144,92,66,98,41,226,144,82,36,130,32,242,249,134,209,118,216,26,19,
			55,253,21,174,4,29,200,105,63,133,41,195,18,10,204,24,63,109,146,139,172,24,223,72,232,12,227,163,97,4,73,66,
			49,163,202,80,138,42,55,196,170,240,36,97,0,213,251,63,163,208,60,197,101,19,36,195,24,164,74,5,226,157,5,250,
			66,42,2,222,221,74,116,129,106,232,74,18,36,189,205,12,212,66,180,160,154,112,243,51,58,77,121,232,42,19,190,136,
			224,243,82,240,124,241,117,11,239,110,51,136,221,172,18,63,18,215,209,248,6,225,231,219,133,238,199,208,52,122,155,37,
			63,71,69,98,226,90,48,102,238,182,14,200,214,50,234,62,200,199,156,129,143,239,145,139,143,111,67,188,48,23,242,212,
			82,187,19,35,32,88,50,134,231,151,124,120,2,241,2,174,78,45,245,196,119,224,198,218,90,35,222,188,244,97,93,116,
			31,71,111,178,113,227,16,135,167,186,74,97,103,40,53,225,174,212,70,107,29,156,81,156,24,0,214,153,136,39,225,190,
			244,131,97,97,106,10,197,235,3,132,19,189,120,16,28,37,157,57,64,249,200,21,58,107,128,242,37,120,127,247,236,1,
			128,60,164,159,51,64,1,177,86,113,110,79,92,147,31,141,38,247,160,121,158,157,177,94,247,48,119,177,116,139,156,63,
			16,144,218,228,2,140,238,253,129,104,149,11,97,39,251,66,209,46,23,13,134,164,111,188,120,160,114,82,219,92,50,80,
			57,185,117,46,29,8,202,237,115,217,64,5,69,11,93,222,7,105,218,232,10,66,142,228,182,101,86,99,93,57,51,14,
			106,181,171,136,99,171,25,112,160,249,174,198,40,59,56,15,218,241,154,25,178,16,245,218,153,125,11,181,236,117,51,251,
			22,110,226,235,103,198,195,109,125,195,204,62,6,141,126,227,160,44,166,245,111,50,235,8,57,151,109,248,164,238,205,4,
			91,69,192,56,72,34,156,150,91,134,245,186,143,240,65,145,120,43,252,72,233,125,213,198,107,137,90,243,186,109,88,47,
			253,164,222,40,51,36,63,219,219,13,201,63,211,124,7,60,165,74,59,172,154,163,118,41,246,59,97,166,164,100,108,94,
			143,116,106,28,235,222,199,221,5,223,197,191,216,237,131,238,70,55,149,83,187,62,208,123,48,11,148,207,120,244,195,222,
			11,5,148,21,54,24,199,125,168,20,235,20,131,69,186,31,243,57,238,61,35,21,220,141,24,225,161,56,67,6,68,63,
			128,177,90,129,229,253,141,94,248,7,135,245,153,170,44,242,67,198,235,145,139,55,194,221,181,206,124,55,211,130,31,70,
			207,200,224,210,167,231,51,120,30,25,150,135,177,228,161,189,20,224,81,120,108,114,178,28,55,203,225,120,52,226,46,107,
			248,12,143,13,171,119,124,220,27,27,62,238,241,97,25,250,178,55,236,9,212,108,143,155,26,62,254,73,148,183,215,205,
			11,159,225,41,203,195,52,211,87,127,146,235,115,61,109,184,172,233,108,63,174,103,136,107,91,117,23,105,6,185,61,203,
			115,127,118,211,240,126,220,115,182,152,25,100,255,60,70,92,101,194,236,147,27,62,240,133,97,117,130,123,68,190,158,154,
			161,199,47,14,171,179,224,22,200,55,72,47,101,129,124,73,47,103,129,124,35,245,138,177,25,253,50,125,53,31,234,103,
			253,90,62,212,47,192,235,108,217,212,58,13,46,14,102,200,123,35,107,209,106,44,108,46,202,192,190,137,5,6,126,137,
			157,195,192,103,32,222,50,70,183,39,238,109,194,109,196,143,159,232,101,55,31,242,14,230,175,106,122,173,53,233,240,233,
			217,179,214,181,46,192,232,25,12,158,179,61,2,68,235,14,139,67,60,210,112,114,21,57,196,163,12,103,154,120,52,17,
			231,202,213,135,188,172,143,177,48,121,37,56,54,37,39,157,215,113,41,57,105,204,241,132,153,147,85,144,113,236,36,2,
			113,2,16,89,197,208,136,19,141,12,55,3,141,56,201,200,200,65,156,76,136,162,61,64,231,228,117,138,193,245,44,211,
			169,190,188,156,124,79,243,229,229,224,78,159,158,237,60,108,166,17,165,110,37,4,45,171,52,68,43,25,62,87,50,209,
			202,134,47,69,171,76,235,109,251,156,92,35,131,200,201,187,234,203,72,229,50,234,203,72,33,198,166,177,245,31,243,214,
			43,34,90,117,212,25,53,189,18,67,128,249,189,0,67,181,166,218,3,96,194,194,105,14,199,81,175,85,178,241,139,136,
			62,175,7,221,151,87,159,158,45,222,191,149,183,42,99,76,228,27,148,184,178,26,250,69,82,147,146,86,179,111,105,114,
			106,60,205,15,26,43,207,66,36,182,184,136,229,118,173,197,81,41,66,234,67,209,144,189,246,49,173,79,24,244,64,181,
			167,197,17,34,65,16,175,49,91,11,28,211,250,108,65,46,166,3,75,34,55,145,26,136,35,201,111,56,171,165,12,54,
			51,19,252,104,74,138,56,78,196,93,44,63,125,198,139,159,19,36,96,251,60,1,61,57,39,137,115,231,20,231,160,235,
			155,83,211,250,140,23,223,121,105,199,37,242,97,53,121,49,106,205,18,158,133,57,147,48,155,170,83,105,61,145,103,77,
			123,7,220,160,117,221,228,108,148,193,74,86,135,113,36,249,156,105,60,101,143,13,106,108,237,199,164,55,231,82,202,90,
			10,229,80,222,157,189,196,44,242,244,112,197,6,193,85,235,245,217,5,56,51,113,163,85,143,80,130,247,208,207,53,91,
			97,187,83,11,113,136,178,90,141,176,204,72,63,150,32,194,138,60,22,15,69,147,181,164,147,44,9,164,72,168,196,81,
			130,75,221,130,178,20,17,150,19,207,184,39,81,103,105,252,170,53,203,109,22,191,12,253,90,170,25,82,119,89,22,249,
			70,34,211,161,184,186,28,253,92,13,34,66,82,56,157,186,124,1,143,60,139,184,137,58,113,133,2,246,93,197,105,73,
			26,78,17,206,3,115,190,21,11,252,86,178,44,137,164,27,242,74,5,236,245,137,147,191,41,222,149,241,113,17,212,181,
			138,189,158,184,186,10,37,172,212,28,9,169,202,233,119,165,91,238,172,74,41,171,136,148,114,44,211,86,51,105,73,183,
			33,214,169,87,199,119,153,89,227,26,40,44,255,28,137,219,35,122,134,185,38,37,47,91,161,114,34,101,173,2,130,167,
			234,57,101,157,122,208,218,168,53,68,105,101,214,117,80,57,106,231,73,7,172,93,23,101,228,231,221,85,202,122,40,143,
			88,180,214,105,235,83,218,10,210,98,225,53,247,13,32,185,220,45,137,95,27,130,138,5,6,190,121,26,119,230,64,2,
			118,187,200,60,215,248,166,70,39,222,8,101,173,53,171,181,102,173,51,53,23,12,98,161,82,44,171,162,65,249,191,141,
			241,21,13,178,215,93,14,156,133,164,2,164,37,45,210,17,222,93,225,180,34,116,15,31,91,137,146,77,10,252,122,184,
			108,50,145,184,41,50,80,119,36,41,247,205,184,142,227,206,144,149,54,12,76,61,30,149,82,43,155,163,206,213,239,184,
			189,5,90,147,187,23,95,29,137,155,1,10,217,109,210,127,243,196,183,116,162,81,18,54,95,100,207,54,64,165,141,32,
			77,190,255,164,210,182,132,22,66,105,112,90,64,37,110,197,170,217,109,243,211,241,42,113,107,112,143,199,245,110,195,164,
			109,195,234,170,159,155,80,201,11,160,174,214,43,20,158,248,109,137,188,145,247,148,133,7,217,14,45,201,29,144,186,114,
			180,61,234,181,20,149,195,110,18,237,128,239,109,67,29,119,68,205,152,246,220,9,44,80,59,86,171,157,233,215,210,209,
			100,57,74,146,247,162,51,143,70,113,35,162,111,47,15,25,142,247,65,192,88,220,136,41,35,42,204,46,104,100,55,110,
			242,251,145,36,109,77,69,196,84,222,21,213,192,55,187,58,124,132,100,49,245,143,221,88,163,225,189,224,73,151,221,193,
			52,129,184,199,99,170,131,237,1,0,26,154,69,236,137,38,22,221,136,127,239,69,191,215,9,147,41,50,43,49,239,213,
			213,167,116,56,230,189,11,216,98,133,237,200,166,239,67,244,181,195,22,229,51,89,163,78,26,89,164,125,137,52,236,146,
			112,139,142,133,149,59,93,71,204,126,132,157,215,140,106,168,242,33,151,167,9,91,234,227,247,71,45,120,145,163,15,160,
			180,53,88,186,155,126,32,172,147,147,70,18,21,241,32,54,189,66,39,185,50,14,70,130,12,38,203,136,67,96,10,16,
			224,115,60,172,195,72,118,226,67,81,39,186,65,85,185,12,253,48,104,165,178,239,164,193,165,168,51,17,69,205,195,161,
			7,252,109,33,13,27,28,130,128,188,129,70,173,115,4,234,48,37,143,51,63,146,72,155,101,87,47,190,2,34,40,29,
			7,233,170,71,17,180,160,126,128,152,205,118,52,190,175,28,215,201,26,138,99,112,199,176,125,22,39,226,56,253,88,244,
			62,182,125,181,166,102,59,78,27,68,149,114,60,212,172,28,183,219,81,210,138,155,28,85,227,4,30,157,146,14,231,153,
			156,8,0,42,134,108,19,95,244,235,196,39,177,193,196,161,38,145,225,201,108,157,163,122,39,212,98,79,65,101,232,111,
			44,145,27,18,177,117,164,254,114,42,235,173,178,130,165,169,211,208,224,106,87,156,82,20,215,233,248,34,30,50,101,66,
			200,70,171,130,193,182,204,9,37,124,34,16,118,98,25,57,39,104,130,142,223,162,149,2,191,140,171,130,146,91,250,19,
			65,185,156,32,227,22,177,90,224,87,149,53,27,30,151,86,180,81,216,40,151,209,38,143,129,108,88,85,199,81,228,26,
			145,231,56,220,62,98,33,15,25,221,178,21,16,125,17,134,58,78,178,57,235,194,184,177,138,54,148,167,224,124,125,147,
			7,236,184,99,36,197,170,254,108,65,45,152,85,213,135,77,209,155,86,133,156,65,144,141,21,196,41,190,141,106,187,223,
			46,40,166,56,73,234,219,125,68,135,16,197,220,146,24,92,23,189,171,87,113,12,116,156,160,235,57,101,178,241,19,160,
			250,69,50,129,232,209,51,179,139,99,243,76,217,176,84,105,52,223,98,12,179,173,118,84,198,139,194,103,226,71,210,45,
			151,163,168,146,156,197,254,165,164,216,122,120,54,8,10,101,19,206,65,185,61,14,243,205,231,130,234,177,25,234,121,208,
			1,237,96,72,33,231,59,137,146,247,2,30,158,68,128,253,184,122,33,219,0,21,41,63,174,94,164,156,144,112,72,99,
			46,214,30,235,144,133,188,4,189,80,99,236,239,184,20,29,205,66,218,180,203,136,54,164,135,22,147,135,163,114,151,219,
			117,239,100,234,192,174,128,229,55,18,84,192,37,77,191,178,192,79,9,24,230,20,226,42,52,24,31,99,37,196,213,40,
			182,250,225,29,110,189,70,244,95,73,99,7,235,90,118,249,132,187,169,12,253,117,24,107,244,164,185,54,90,131,95,25,
			87,175,47,152,155,201,246,152,160,138,113,3,250,106,154,205,134,220,8,239,68,221,81,11,91,55,217,63,187,173,155,121,
			24,177,222,246,189,5,70,66,37,176,115,113,171,157,66,99,66,148,220,6,11,107,246,133,109,167,252,3,80,81,77,138,
			141,143,125,59,26,93,17,28,143,252,142,130,142,72,96,206,166,105,234,157,60,60,73,170,24,109,238,178,203,140,109,147,
			187,145,160,142,141,225,35,238,65,145,85,2,127,196,189,118,10,127,196,125,220,153,206,80,81,118,76,73,239,71,13,201,
			243,11,97,121,209,3,208,122,113,250,129,126,61,40,188,67,60,178,68,191,30,130,205,197,11,81,244,255,195,160,132,73,
			18,177,79,248,8,252,198,70,76,99,98,242,40,253,187,100,167,221,141,30,67,26,249,161,228,76,62,14,203,38,221,21,
			251,100,149,58,55,65,147,125,26,13,235,209,19,5,126,231,200,125,247,19,56,153,230,193,159,228,113,216,244,101,26,138,
			158,130,162,178,203,72,37,120,218,161,115,81,158,161,164,5,188,91,200,213,48,104,78,207,66,229,181,197,65,56,30,42,
			123,84,103,149,127,78,244,98,105,111,92,218,243,208,115,234,138,13,188,95,218,45,141,182,99,170,190,184,250,2,244,220,
			158,115,122,144,23,121,76,74,177,217,122,254,18,220,212,30,34,108,236,203,176,93,86,127,121,5,149,164,250,215,171,186,
			107,55,194,214,107,24,195,200,152,144,123,71,254,15,230,23,11,187,168,171,33,114,141,218,181,201,215,33,136,167,81,84,
			93,148,252,6,253,94,98,50,110,191,137,54,111,210,180,235,45,36,80,73,222,134,182,217,115,66,17,145,162,93,126,7,
			77,226,222,34,254,32,91,77,158,50,91,19,184,15,241,88,237,164,198,237,15,115,117,114,162,61,153,251,8,138,37,146,
			217,226,124,148,205,185,60,50,168,244,252,99,232,53,182,226,127,188,160,143,170,203,148,79,20,236,89,55,119,155,79,66,
			137,75,241,68,167,22,125,170,160,222,193,147,85,77,243,60,60,71,131,39,8,197,251,147,106,222,242,233,130,122,55,166,
			47,244,51,194,215,146,47,25,186,180,207,194,73,147,167,48,83,196,207,193,192,184,115,44,105,47,62,143,175,87,59,8,
			170,230,190,128,74,118,19,169,146,191,88,224,120,41,172,241,98,124,248,82,193,76,128,213,136,240,101,56,172,214,164,88,
			85,251,87,68,141,114,58,215,251,87,97,19,90,181,78,121,140,250,218,162,175,161,132,66,5,177,236,103,77,214,191,142,
			102,52,30,133,138,208,240,13,48,56,30,132,162,124,19,37,224,213,46,215,53,252,22,44,179,73,183,121,191,93,224,221,
			75,149,135,61,253,176,97,223,1,204,201,211,70,106,254,239,154,111,241,40,223,67,35,229,73,255,62,186,129,77,84,38,
			228,7,62,65,217,143,31,22,248,205,123,215,61,209,125,249,71,14,85,242,104,234,143,11,252,180,175,94,141,206,26,65,
			127,194,30,67,108,173,88,103,142,162,63,133,168,12,49,182,79,240,51,136,202,22,99,195,126,94,112,94,70,178,28,126,
			227,148,253,34,213,10,153,176,95,194,44,106,43,156,9,249,21,123,8,202,24,103,66,126,13,165,65,106,218,192,254,6,
			227,84,214,130,161,7,253,173,170,197,222,54,250,119,4,155,63,128,56,205,243,123,244,82,61,28,69,245,122,173,149,212,
			146,63,96,180,160,254,143,125,67,59,122,155,162,255,17,70,91,191,76,169,3,170,40,242,159,136,188,161,245,206,100,10,
			240,103,152,43,179,152,170,98,117,224,86,149,255,174,251,95,8,186,147,15,117,198,207,144,106,91,172,154,166,152,255,74,
			204,187,250,75,183,51,19,241,55,116,0,159,25,70,157,159,174,154,134,49,245,169,152,159,146,212,191,179,143,155,153,185,
			68,252,131,123,178,71,227,225,156,136,255,204,170,35,68,120,76,21,49,249,87,1,155,248,106,100,238,81,153,255,38,224,
			14,46,112,208,122,248,15,177,238,226,45,93,207,72,192,127,217,63,117,88,101,53,252,143,125,240,12,209,146,254,46,154,
			96,49,52,90,108,141,148,194,81,185,100,158,140,213,90,179,138,24,81,104,232,141,168,43,243,186,246,236,34,214,83,234,
			52,100,96,25,145,183,186,223,67,73,75,141,197,221,36,90,162,40,94,13,211,7,107,150,44,170,87,195,116,210,82,69,
			177,96,185,16,163,206,120,180,116,17,171,193,148,91,75,252,94,166,136,203,123,98,143,170,25,45,11,129,226,112,109,132,
			187,63,163,203,21,121,5,136,143,209,138,148,229,33,79,196,21,172,199,113,123,133,162,94,190,230,223,43,210,239,213,100,
			224,86,201,215,142,91,43,81,234,170,50,85,136,167,196,149,81,88,68,101,53,184,85,144,29,146,52,104,85,200,211,3,
			53,155,94,170,149,213,192,42,141,167,140,231,176,58,37,45,65,46,210,26,69,220,112,137,70,161,106,107,210,255,75,99,
			184,141,219,107,209,191,171,155,75,150,100,5,227,54,233,230,218,72,110,197,9,47,53,209,240,92,193,68,44,110,175,83,
			196,178,115,45,154,168,132,157,80,26,251,117,41,109,237,86,29,171,211,177,220,108,226,183,6,168,56,235,1,174,183,234,
			69,218,250,104,165,9,196,85,220,0,85,76,237,213,30,165,57,79,178,33,99,245,39,114,80,202,57,168,30,171,38,56,
			113,35,20,205,169,51,78,158,91,68,148,29,167,130,57,125,8,21,5,25,50,10,152,88,210,222,152,82,215,148,104,135,
			80,64,241,170,184,41,91,196,127,73,131,220,244,77,138,252,168,170,209,29,181,136,233,119,85,210,227,100,83,232,65,220,
			226,122,91,20,77,109,134,210,146,31,152,68,24,146,177,68,201,133,27,70,254,147,88,83,12,77,76,199,161,82,60,185,
			57,17,150,37,62,222,67,219,130,126,108,208,227,72,122,64,244,13,123,157,65,159,135,143,119,114,135,180,249,208,230,82,
			212,36,253,136,120,22,57,130,132,242,20,169,113,133,122,83,173,51,181,37,74,141,190,26,138,67,127,212,79,170,84,17,
			91,161,112,201,84,3,107,179,83,91,131,169,19,227,187,219,221,102,220,237,108,83,100,255,152,20,140,29,93,49,120,47,
			128,230,82,143,23,203,138,33,245,176,109,185,94,113,55,119,59,244,145,50,101,64,42,83,194,206,130,245,59,169,53,23,
			237,128,207,11,91,228,231,118,155,101,185,75,36,110,224,12,213,70,74,81,216,216,177,136,103,184,51,1,164,155,120,31,
			16,65,158,118,34,212,80,54,10,100,49,70,238,156,47,138,65,98,207,232,189,132,42,244,68,241,236,224,125,69,236,169,
			228,195,22,198,157,93,250,228,39,102,230,239,207,207,79,198,28,226,121,228,174,249,95,40,97,148,227,110,4,154,155,83,
			89,88,116,128,246,238,78,152,98,54,6,103,241,52,110,143,62,85,202,192,61,9,180,73,15,144,150,184,87,31,160,118,
			243,246,46,242,38,74,46,208,246,245,246,201,23,106,5,217,15,155,209,190,4,220,52,27,104,199,203,39,228,126,132,12,
			122,150,211,137,236,187,63,193,231,245,128,251,71,181,14,40,242,246,70,143,86,212,53,118,32,44,82,54,84,47,171,104,
			39,227,160,124,85,19,187,13,172,67,7,231,87,131,80,109,142,110,64,246,190,115,72,159,198,103,161,135,230,107,146,41,
			33,105,229,97,249,26,174,223,54,160,170,63,60,255,131,57,79,39,82,244,17,249,159,34,151,153,148,215,113,100,126,159,
			168,240,93,98,170,152,163,242,191,68,102,45,170,229,232,62,157,158,4,30,147,223,18,170,96,84,37,199,230,107,174,245,
			30,3,85,202,113,125,244,209,11,21,125,124,175,110,22,35,208,161,84,152,19,122,20,128,21,70,1,79,204,215,88,181,
			78,162,160,39,229,183,51,125,178,134,157,156,223,116,178,15,40,228,41,61,235,50,25,139,217,232,157,218,75,87,99,190,
			71,26,86,78,203,23,165,173,108,216,62,189,143,218,243,118,97,152,111,161,84,11,83,205,192,67,170,37,165,30,93,36,
			170,27,92,57,191,57,120,157,73,3,43,249,2,23,242,177,7,137,139,250,26,26,13,173,230,183,135,120,20,10,245,204,
			221,100,52,31,41,22,162,52,114,44,31,41,22,156,116,238,53,66,206,207,70,58,211,122,205,176,48,191,63,139,179,87,
			164,56,139,122,247,121,46,66,29,142,87,54,102,49,232,141,30,142,7,62,81,72,105,230,27,45,172,188,137,125,103,165,
			207,113,159,65,80,47,126,180,250,216,35,181,7,124,70,143,206,169,109,185,40,104,59,63,111,101,221,4,48,33,224,250,
			57,30,25,102,110,68,94,47,103,40,37,71,63,191,82,227,70,52,26,142,231,151,130,190,122,204,152,157,137,252,47,139,
			90,73,205,174,213,201,252,202,66,129,53,110,42,63,111,46,155,6,46,206,255,8,46,228,153,152,129,241,186,140,142,227,
			114,22,108,66,106,213,218,24,231,197,181,209,197,52,219,21,143,18,21,57,168,70,220,69,171,168,80,9,52,45,56,7,
			174,113,9,215,63,69,102,231,210,239,57,122,86,206,75,56,226,17,207,90,165,130,254,27,119,206,131,55,78,179,108,177,
			147,34,217,206,47,202,29,130,90,179,75,19,101,241,85,204,45,232,23,96,12,171,144,201,201,135,92,136,121,90,212,160,
			79,197,133,96,145,118,81,145,15,202,53,244,132,81,36,95,92,204,12,23,43,35,63,56,165,191,164,200,231,226,120,118,
			207,188,151,98,86,137,16,48,237,166,184,130,69,115,34,73,186,12,117,49,22,213,27,242,247,229,232,140,250,122,131,51,
			27,179,94,129,185,162,104,109,157,233,176,187,104,133,43,49,52,149,176,124,161,194,55,41,182,118,103,204,188,226,112,21,
			178,165,218,136,101,182,87,99,110,69,99,92,76,70,152,215,181,57,245,26,164,142,77,37,29,97,144,100,234,181,40,34,
			31,212,231,64,207,181,14,14,236,183,186,157,161,177,145,206,84,75,241,94,151,135,170,219,168,235,97,191,90,52,99,174,
			225,78,78,183,94,231,71,173,21,84,96,110,128,122,56,152,110,203,69,220,40,90,154,215,254,203,221,54,206,94,42,61,
			174,198,237,6,102,182,55,21,113,144,49,102,159,54,26,81,250,46,81,55,231,91,2,88,161,91,48,117,171,68,229,26,
			47,72,70,88,165,199,78,133,105,196,91,49,47,108,181,163,241,26,148,172,21,142,70,183,97,57,160,25,77,118,248,215,
			7,208,17,90,109,92,73,75,202,34,206,21,243,221,142,116,106,34,106,91,39,253,14,53,85,118,238,171,203,40,218,113,
			188,232,206,226,44,241,202,163,67,167,220,196,108,245,174,76,118,243,202,201,221,122,166,157,35,255,30,8,72,3,116,6,
			247,102,11,48,57,220,7,247,66,140,148,162,175,168,139,217,34,15,177,152,113,63,218,53,11,164,243,121,32,79,140,200,
			73,136,121,16,138,38,183,128,242,51,123,8,42,146,137,210,185,61,156,43,200,206,238,17,93,106,247,202,185,169,189,71,
			139,188,154,159,66,72,115,214,170,69,229,232,177,28,41,166,10,31,39,196,58,46,81,151,244,9,243,49,121,133,120,18,
			85,151,5,177,75,241,84,158,28,83,140,167,97,13,213,122,146,41,193,51,24,28,45,243,196,54,85,83,159,37,234,86,
			86,20,106,108,6,89,81,85,220,188,228,78,217,115,134,71,160,52,83,70,53,73,158,231,209,239,244,25,98,92,112,124,
			161,200,231,75,85,138,88,20,123,17,223,192,47,67,57,205,250,18,140,168,122,126,202,161,188,76,148,145,76,138,56,202,
			149,150,245,10,100,181,195,10,143,1,106,145,129,5,188,90,84,47,8,152,117,231,120,146,43,236,181,162,126,65,32,69,
			123,29,108,246,146,116,153,92,67,16,70,182,121,35,151,180,237,155,185,164,29,223,202,37,237,252,54,62,151,143,203,37,
			157,182,178,105,67,94,76,24,236,79,234,213,203,119,136,99,235,65,56,236,53,204,15,98,9,161,31,147,24,84,121,224,
			250,16,225,119,200,193,139,229,239,166,51,68,90,172,31,38,214,237,114,88,177,246,153,203,248,145,65,170,66,108,108,168,
			215,64,136,99,167,153,150,82,49,127,172,199,39,230,148,83,177,126,28,254,248,32,77,128,131,195,159,232,81,31,185,133,
			4,227,39,137,113,193,204,10,8,182,79,97,50,63,120,126,159,238,241,45,169,92,62,131,121,212,160,218,138,142,247,89,
			88,150,25,40,43,120,62,87,52,231,255,171,113,220,249,60,44,13,205,28,186,109,53,70,127,129,157,60,108,184,200,132,
			47,162,55,187,94,172,54,136,95,42,242,41,127,113,8,152,108,70,52,30,125,25,14,137,78,226,221,47,182,45,228,47,
			183,59,95,113,136,156,36,168,192,125,21,99,71,6,39,214,239,25,154,124,205,65,152,116,35,227,235,240,32,178,16,11,
			99,220,188,252,6,204,168,33,183,105,154,221,136,190,9,51,106,18,233,159,16,201,223,114,146,91,8,110,132,228,111,115,
			253,132,184,34,49,202,235,238,223,161,132,37,171,221,36,250,110,81,110,142,88,190,195,247,138,102,31,196,74,254,126,81,
			238,119,56,230,255,7,69,179,223,225,16,126,136,175,2,60,59,202,204,143,80,45,146,47,27,241,227,162,126,214,138,190,
			174,21,45,174,117,27,63,65,91,216,27,12,182,189,248,41,190,146,212,42,132,54,53,163,36,249,25,37,44,139,168,67,
			248,241,115,250,177,124,88,86,62,233,47,138,98,239,181,44,235,202,62,40,242,75,208,148,143,25,77,182,226,166,113,98,
			127,133,249,92,230,51,5,234,38,152,180,9,191,46,234,183,164,220,141,22,15,247,27,120,58,233,103,18,60,212,111,141,
			52,247,173,3,15,247,59,24,177,65,138,151,222,126,253,61,177,110,63,64,129,211,156,127,200,205,212,127,213,36,117,126,
			237,143,232,219,97,61,164,137,1,95,19,249,19,124,245,132,212,134,55,242,254,12,42,206,53,181,5,245,47,240,133,245,
			198,158,16,90,37,199,132,223,133,34,171,241,87,83,75,153,49,164,84,113,254,102,26,49,59,118,148,2,78,155,198,145,
			192,172,55,86,254,158,202,54,251,41,174,127,20,205,193,36,187,18,254,89,52,193,113,149,153,35,227,67,181,240,175,162,
			9,183,41,38,144,160,136,189,212,127,67,221,91,236,149,9,213,252,15,207,108,56,33,166,105,91,181,42,211,255,139,142,
			164,210,101,218,255,138,188,13,203,204,245,40,106,201,228,119,33,34,46,209,220,158,79,201,79,169,169,225,172,128,58,179,
			188,58,150,113,122,116,118,128,235,43,14,153,239,137,41,250,123,136,190,161,75,231,211,106,26,176,4,1,230,88,39,226,
			52,65,159,152,88,50,192,17,195,92,4,178,91,42,192,41,23,113,151,77,30,5,178,58,181,102,88,218,20,86,194,92,
			129,203,4,136,154,57,17,219,7,207,52,113,217,0,161,131,45,98,108,142,227,45,71,180,53,133,96,247,235,150,15,48,
			226,196,149,110,61,22,230,189,219,88,33,224,67,152,202,55,230,111,80,158,253,138,40,32,230,186,237,174,125,135,75,139,
			91,9,249,240,109,13,126,138,175,163,17,43,131,81,195,237,46,39,14,81,172,226,208,201,53,104,227,164,20,227,120,243,
			103,213,64,158,14,238,138,211,160,122,10,190,90,128,229,55,231,42,151,20,195,247,5,137,186,128,199,88,43,81,190,59,
			36,118,160,249,94,74,43,228,35,149,252,80,73,43,174,71,107,16,219,182,217,108,188,136,169,30,174,242,249,214,36,190,
			225,20,31,95,51,105,150,235,221,10,247,184,177,136,177,107,17,214,84,160,20,18,202,136,52,170,62,215,134,118,34,98,
			73,212,110,138,67,9,94,133,175,131,28,221,122,205,124,133,24,115,180,117,161,61,46,86,40,3,31,91,64,55,114,137,
			182,138,174,79,228,53,92,50,171,230,6,148,190,150,155,46,183,153,54,36,202,218,62,135,88,79,156,67,164,37,225,65,
			108,132,207,19,129,186,157,87,133,244,231,205,69,231,179,78,200,36,229,177,168,17,14,217,203,110,248,168,52,162,85,107,
			81,101,111,12,249,25,68,121,2,38,110,22,8,176,177,190,55,42,91,216,122,192,70,28,134,42,18,106,51,15,197,58,
			208,168,214,163,201,161,176,140,213,61,1,221,4,213,232,65,197,2,63,147,55,69,105,61,50,172,85,41,162,161,98,179,
			92,94,38,15,227,99,252,178,118,75,242,74,58,117,222,205,81,89,30,64,62,172,34,235,117,139,128,143,191,53,221,47,
			225,77,2,46,94,128,206,228,211,117,249,230,161,0,62,181,74,149,37,70,226,78,50,63,75,60,57,133,138,62,226,22,
			176,214,180,158,10,19,245,189,37,76,169,131,176,158,7,19,144,173,2,246,159,249,16,48,253,137,88,175,242,36,239,214,
			48,179,94,136,112,247,67,248,51,183,65,171,231,194,148,150,46,8,16,57,56,117,90,88,214,171,116,43,235,113,18,85,
			182,13,176,190,208,192,57,1,9,218,14,221,50,43,135,140,111,222,158,176,155,231,96,83,95,191,3,12,154,190,100,145,
			247,9,41,229,220,145,216,54,201,201,67,221,211,103,161,59,5,214,138,177,19,137,107,103,80,156,166,81,90,245,94,244,
			116,171,217,45,210,251,136,52,55,39,95,133,217,37,224,69,123,220,222,224,99,189,92,129,239,71,95,224,175,71,56,250,
			33,159,188,43,90,208,234,216,234,146,64,88,183,109,195,110,60,54,80,119,30,85,97,78,161,48,234,126,249,238,202,116,
			233,97,88,105,201,30,160,136,145,87,110,48,168,111,219,51,64,212,123,67,145,182,110,47,100,148,22,37,169,123,67,237,
			211,84,107,12,223,199,203,208,140,224,251,194,96,8,10,171,174,99,148,247,83,6,93,11,22,24,198,239,143,190,96,115,
			242,49,198,148,140,3,0,203,144,97,208,44,227,64,35,173,68,51,46,216,179,102,69,206,2,173,225,224,32,130,109,237,
			72,203,65,219,152,131,241,25,162,39,13,89,149,192,129,28,146,67,160,65,146,152,174,67,129,57,52,224,224,4,194,157,
			72,187,87,135,5,198,183,181,221,170,195,41,61,200,203,151,75,236,244,233,35,144,139,237,120,185,70,229,72,232,128,229,
			122,185,212,163,160,56,178,12,150,140,163,3,19,169,200,240,30,3,67,11,111,204,124,5,226,247,24,182,99,97,104,115,
			1,113,251,56,116,41,28,55,227,100,249,206,198,241,200,203,77,36,81,39,160,97,109,143,145,116,182,30,182,90,94,142,
			39,242,72,237,127,188,92,36,70,100,226,147,80,36,255,243,45,250,201,1,191,2,234,9,176,22,133,112,29,235,148,128,
			223,47,117,133,120,152,83,109,140,213,12,92,135,178,199,157,102,183,133,198,40,195,126,122,102,81,244,237,11,1,10,217,
			11,102,87,96,60,138,92,1,37,140,82,233,166,182,75,80,206,250,18,47,139,138,103,196,42,113,131,15,181,55,241,180,
			150,184,134,76,201,17,74,107,155,58,126,47,197,3,85,161,155,214,163,38,222,200,61,202,134,66,223,116,118,85,115,140,
			136,219,200,27,101,89,59,137,254,172,80,56,236,181,62,92,254,21,53,193,181,16,166,208,141,112,224,149,102,17,42,46,
			11,97,249,17,117,152,203,164,214,168,193,7,87,198,153,127,53,216,148,196,205,209,118,23,46,153,43,186,25,168,155,34,
			114,126,174,174,12,198,240,239,188,152,1,57,3,105,43,224,131,20,233,123,245,246,29,103,116,5,187,49,132,29,213,99,
			103,27,116,51,146,10,170,133,79,208,226,105,126,183,82,58,150,65,177,46,243,119,149,233,160,74,32,187,208,229,109,100,
			91,246,56,116,87,60,139,149,7,153,128,143,145,82,38,8,69,229,203,210,240,202,169,74,98,37,155,68,213,88,215,67,
			132,123,136,152,26,134,109,138,205,136,123,93,73,122,218,181,38,6,138,197,16,146,190,184,228,96,206,12,156,251,72,12,
			112,67,227,115,94,103,193,127,75,139,202,64,158,29,240,46,155,117,181,155,230,156,28,246,81,95,147,70,147,248,215,187,
			125,208,185,4,26,233,41,198,40,164,248,146,243,48,92,246,19,235,51,157,79,76,243,7,204,134,63,239,2,98,216,106,
			240,92,152,231,66,158,56,207,32,19,225,170,94,68,108,219,205,48,43,118,136,47,70,199,117,242,179,58,217,37,232,48,
			190,84,139,126,41,250,175,97,230,145,155,227,241,143,240,92,220,190,66,117,25,65,183,112,68,245,66,95,238,42,6,160,
			124,39,221,100,125,69,74,49,50,64,87,162,86,44,49,252,213,162,239,138,60,229,213,62,78,183,133,93,149,170,206,222,
			188,58,143,171,121,136,243,114,84,22,83,153,170,107,8,84,204,144,238,227,174,133,159,148,39,44,93,232,235,0,239,33,
			214,43,234,245,89,149,51,200,55,223,144,83,57,125,43,250,70,98,220,59,245,61,142,146,230,150,194,129,221,4,65,253,
			64,57,165,114,48,55,67,207,82,221,196,190,27,121,11,26,52,11,97,103,127,43,12,80,79,49,190,45,185,13,6,168,
			159,88,159,233,3,240,91,210,42,232,101,117,59,166,156,121,40,91,252,29,232,146,54,176,231,23,220,25,240,69,192,222,
			104,91,252,93,24,245,45,149,214,146,238,102,15,207,16,108,166,123,80,166,28,133,77,15,216,247,162,76,249,29,34,205,
			112,31,178,150,131,119,147,134,163,200,58,239,127,191,53,153,145,52,91,216,3,24,213,114,88,93,47,245,193,192,191,9,
			234,248,246,138,233,161,32,21,72,70,76,217,52,226,225,192,137,124,34,103,76,165,41,17,115,249,17,12,233,14,191,7,
			120,212,29,22,61,106,86,119,120,44,53,44,14,192,244,120,128,45,54,56,236,216,227,36,166,39,2,126,153,141,230,57,
			226,247,147,129,138,81,39,19,108,159,237,41,180,136,5,182,105,79,227,11,83,254,80,169,219,104,77,137,130,60,131,241,
			71,95,166,85,214,206,12,41,22,239,179,128,234,75,181,61,161,207,97,13,169,135,84,123,160,122,30,216,30,98,109,236,
			11,80,48,79,174,149,237,139,32,123,162,44,242,75,236,188,186,220,182,244,151,3,14,144,226,176,219,244,87,2,251,226,
			177,244,37,93,215,251,213,192,190,120,156,9,121,13,186,157,81,10,15,246,58,96,25,133,241,96,111,4,230,166,190,18,
			250,102,96,223,222,23,18,222,66,154,12,254,162,108,226,219,60,171,86,1,95,84,234,59,129,9,19,163,55,129,132,242,
			176,175,252,193,192,14,19,147,133,248,16,250,185,45,33,107,21,141,145,31,22,109,111,203,202,197,126,4,70,57,51,128,
			142,231,148,125,84,232,105,102,60,29,15,250,177,192,9,137,147,210,152,143,7,94,72,156,20,226,19,162,193,93,9,238,
			116,231,147,60,254,165,132,184,160,79,97,242,224,203,241,218,250,211,24,188,210,130,60,212,103,208,229,125,73,182,26,127,
			86,20,217,23,99,67,62,199,223,45,239,165,242,241,54,121,174,89,151,247,243,129,137,193,35,15,179,249,144,47,4,184,
			74,40,172,159,40,207,23,161,132,58,69,20,224,75,176,208,14,202,110,175,47,163,129,60,14,155,254,149,192,68,85,146,
			166,67,162,190,42,40,146,69,209,0,252,90,128,51,219,46,15,126,124,61,176,227,48,185,210,190,17,32,188,154,162,201,
			81,70,176,125,147,72,91,250,36,107,205,176,36,94,57,48,155,30,81,231,91,108,149,205,53,114,84,157,88,32,144,103,
			204,191,141,236,116,8,13,57,137,141,112,41,180,245,29,12,5,157,118,72,211,97,68,210,117,143,88,124,55,16,241,91,
			23,145,180,239,209,255,203,55,227,166,252,249,125,54,0,124,204,70,199,245,249,129,73,211,151,188,126,136,86,19,105,242,
			6,204,143,224,133,208,231,81,33,43,53,177,121,40,190,229,199,112,194,157,171,230,114,229,196,11,155,243,19,152,178,172,
			40,59,162,32,10,246,83,192,178,162,240,184,176,159,25,159,43,51,102,143,139,254,57,143,224,56,64,196,141,80,109,171,
			91,200,226,178,58,191,79,234,202,250,5,247,31,183,82,156,53,241,95,178,209,176,107,200,117,94,126,133,106,113,233,82,
			153,92,161,191,14,56,220,24,103,174,19,127,19,240,205,119,177,216,38,184,127,11,101,112,118,156,245,229,236,223,193,106,
			232,91,229,217,152,223,7,118,248,9,113,47,86,109,35,171,235,232,252,110,138,138,102,245,7,8,205,184,171,96,111,43,
			254,177,55,134,13,246,159,80,79,94,21,218,244,63,7,124,48,94,198,131,241,215,75,101,164,9,52,134,139,113,237,230,
			95,131,156,152,82,165,90,19,71,6,212,238,202,223,48,179,203,194,101,231,59,13,235,33,225,98,137,74,101,248,119,88,
			9,73,241,157,216,127,192,255,112,105,182,43,248,207,188,217,66,102,112,198,127,229,205,22,242,2,54,254,27,38,89,230,
			46,3,64,251,181,240,31,116,49,177,126,158,85,23,234,27,255,107,249,248,74,146,162,253,143,104,171,139,243,99,54,239,
			187,48,75,226,148,70,154,72,134,99,214,77,183,207,158,245,127,100,248,12,143,
		};
		LoadFromString(map, ZDecompress(data, __countof(data)));
	}
	return map;
}

}
